package com.elitescloud.boot.jpa.support.id.config;

import com.elitescloud.boot.jpa.support.id.common.WorkerAssignerType;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.config.SnowflakeProperties;
import com.elitescloud.boot.jpa.support.id.provider.uidgenerator.config.UidProperties;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.io.Serializable;
import java.time.Duration;

/**
 * ID相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/14
 */
@Data
@ConfigurationProperties(prefix = IdProperties.CONFIG_PREFIX)
public class IdProperties implements Serializable {
    private static final long serialVersionUID = -7557278001465397598L;
    public static final String CONFIG_PREFIX = "elitesland.id";

    /**
     * 是否使用默认数据源
     */
    private Boolean useDefaultDatasource = false;

    /**
     * 生成器类型，默认雪花算法
     */
    private GenType genType = GenType.SNOWFLAKE;

    /**
     * Worker分配类型，默认手动指定（本地开发建议使用该模式）
     */
    private WorkerAssignerType assignerType = WorkerAssignerType.MANUAL;

    /**
     * key的存活时间
     */
    private Duration alive = Duration.ofMinutes(20);

    /**
     * 心跳间隔，必须大于alive
     */
    private Duration heartBeat = Duration.ofMinutes(5);

    /**
     * 雪花算法配置
     */
    @NestedConfigurationProperty
    private SnowflakeProperties snowflake = new SnowflakeProperties();

    /**
     * 百度的uid-generator算法
     */
    @NestedConfigurationProperty
    private UidProperties uid = new UidProperties();

    public Boolean getUseDefaultDatasource() {
        return useDefaultDatasource;
    }

    public void setUseDefaultDatasource(Boolean useDefaultDatasource) {
        this.useDefaultDatasource = useDefaultDatasource;
    }

    public GenType getGenType() {
        return genType;
    }

    public void setGenType(GenType genType) {
        this.genType = genType;
    }

    public WorkerAssignerType getAssignerType() {
        return assignerType;
    }

    public void setAssignerType(WorkerAssignerType assignerType) {
        this.assignerType = assignerType;
    }

    public Duration getAlive() {
        return alive;
    }

    public void setAlive(Duration alive) {
        this.alive = alive;
    }

    public Duration getHeartBeat() {
        return heartBeat;
    }

    public void setHeartBeat(Duration heartBeat) {
        this.heartBeat = heartBeat;
    }

    public SnowflakeProperties getSnowflake() {
        return snowflake;
    }

    public void setSnowflake(SnowflakeProperties snowflake) {
        this.snowflake = snowflake;
    }

    public void setUid(UidProperties uid) {
        this.uid = uid;
    }

    public UidProperties getUid() {
        return uid;
    }
}
