package com.elitescloud.boot.jpa.support.id.provider.uidgenerator;

import com.elitescloud.boot.jpa.support.id.provider.uidgenerator.worker.WorkerIdAssigner;
import com.elitescloud.boot.provider.CloudtIdCreator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/**
 * 基于百度的uid-generator.
 * <p>
 * 源码地址 <a href="https://github.com/baidu/uid-generator/blob/master/README.zh_cn.md">uid-generator</a>
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/9
 */
public class UidProvider implements CloudtIdCreator, InitializingBean {

    private final UidGenerator uidGenerator;
    private final WorkerIdAssigner workerIdAssigner;

    public UidProvider(UidGenerator uidGenerator, WorkerIdAssigner workerIdAssigner) {
        this.uidGenerator = uidGenerator;
        this.workerIdAssigner = workerIdAssigner;
    }

    @Override
    public Long create() {
        return uidGenerator.getUID();
    }

    @Override
    public void refreshWorkerAssigner() {
        workerIdAssigner.refreshAlive();
    }

    @Override
    public void destroy() {
        workerIdAssigner.destroy();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(uidGenerator != null, "UidGenerator尚未初始化");
    }
}
