package com.elitescloud.boot.jpa.support.id.provider.uidgenerator.worker;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.jpa.support.id.config.IdProperties;
import com.elitescloud.cloudt.context.util.SystemUtil;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/9
 */
abstract class AbstractWorkerIdAssigner implements WorkerIdAssigner {

    /**
     * workerId最大值
     *
     * @param idProperties
     * @return
     */
    protected long maxWorkerId(IdProperties idProperties) {
        return ~(-1L << idProperties.getUid().getWorkerBits());
    }

    /**
     * 获取当前IP
     *
     * @return
     */
    protected String getIp() {
        var address = SystemUtil.getCurrentAddress();
        return ObjectUtil.defaultIfNull(address.getHostAddress(), "127.0.0.1");
    }
}
