/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.support.id.provider.snowflake.assigner;

import com.elitescloud.boot.jpa.support.id.config.IdProperties;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.WorkerInfo;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.assigner.AbstractSnowflakeWorkerAssigner;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.config.SnowflakeProperties;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.micro.Snowflake;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.StringUtils;

public class RedisSnowflakeWorkerAssigner
extends AbstractSnowflakeWorkerAssigner {
    private static final Logger log = LogManager.getLogger(RedisSnowflakeWorkerAssigner.class);
    private static String CACHE_KEY = "cloudt_snowflake";
    private final String dataCenterName;
    private final IdProperties idProperties;
    private final RedisTemplate redisTemplate;
    private Long dataCenterId;
    private Long workerId;

    public RedisSnowflakeWorkerAssigner(String dataCenterName, IdProperties idProperties, RedisTemplate redisTemplate) {
        this.dataCenterName = dataCenterName;
        this.idProperties = idProperties;
        this.redisTemplate = redisTemplate;
    }

    @Override
    protected WorkerInfo distribute() {
        SnowflakeProperties snowflakeProperties = this.idProperties.getSnowflake();
        if (StringUtils.hasText((String)snowflakeProperties.getCachePrefix())) {
            CACHE_KEY = snowflakeProperties.getCachePrefix();
        }
        this.generateDataCenterId();
        this.generateWorkerId();
        return new WorkerInfo(this.dataCenterId, this.workerId);
    }

    @Override
    public void refreshAlive() {
        ValueOperations opsValue = this.redisTemplate.opsForValue();
        Duration alive = this.idProperties.getAlive();
        opsValue.set((Object)this.cacheKeyDataCenterID(), (Object)this.dataCenterId.toString(), alive);
        opsValue.set((Object)this.cacheKeyDataCenterID(this.dataCenterId), (Object)this.dataCenterName, alive);
        opsValue.set((Object)this.cacheKeyWorkerId(this.workerId), (Object)this.getIp(), alive);
    }

    @Override
    public void destroy() {
        try {
            this.redisTemplate.delete((Object)this.cacheKeyWorkerId(this.workerId));
        }
        catch (Exception e) {
            log.error("\u9500\u6bc1IdGenerator\u5f02\u5e38\uff1a", (Throwable)e);
        }
        log.info("ID\u751f\u6210\u5668\u5b9e\u4f8b\u9500\u6bc1\uff1a{}\u3010{}-{}\u3011", (Object)this.dataCenterName, (Object)this.dataCenterId, (Object)this.workerId);
    }

    private void generateDataCenterId() {
        long temp;
        this.dataCenterId = this.existsDataCenterId();
        if (this.dataCenterId != null) {
            return;
        }
        long max = Snowflake.getMaxDataCenterId();
        ValueOperations opsValue = this.redisTemplate.opsForValue();
        for (temp = 0L; temp < max; ++temp) {
            Boolean result = opsValue.setIfAbsent((Object)this.cacheKeyDataCenterID(temp), (Object)this.dataCenterName, this.idProperties.getAlive());
            if (!Boolean.TRUE.equals(result)) continue;
            this.checkDataCenterId(temp);
            break;
        }
        if (temp >= max) {
            throw new IllegalStateException("dataCenterId\u8d85\u8fc7\u9650\u5236" + max);
        }
    }

    private void checkDataCenterId(Long tempDataCenterId) {
        Boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)this.cacheKeyDataCenterID(), (Object)tempDataCenterId.toString(), this.idProperties.getAlive());
        if (Boolean.TRUE.equals(result)) {
            this.dataCenterId = tempDataCenterId;
            return;
        }
        this.dataCenterId = this.existsDataCenterId();
        this.redisTemplate.delete((Object)this.cacheKeyDataCenterID(tempDataCenterId));
    }

    private Long existsDataCenterId() {
        Object val = this.redisTemplate.opsForValue().get((Object)this.cacheKeyDataCenterID());
        if (val == null || val instanceof Long) {
            return (Long)val;
        }
        return Long.parseLong(val.toString());
    }

    private void generateWorkerId() {
        long max = Snowflake.getMaxWorkerId();
        ValueOperations opsValue = this.redisTemplate.opsForValue();
        String ip = super.getIp();
        for (long temp = 0L; temp < max; ++temp) {
            Boolean result = opsValue.setIfAbsent((Object)this.cacheKeyWorkerId(temp), (Object)ip, this.idProperties.getAlive());
            if (!Boolean.TRUE.equals(result)) continue;
            this.workerId = temp;
            return;
        }
        throw new IllegalStateException("workerId\u8d85\u8fc7\u9650\u5236" + max);
    }

    private String cacheKeyDataCenterID() {
        return CACHE_KEY + ":" + this.dataCenterName;
    }

    private String cacheKeyDataCenterID(Long theDataCenterId) {
        return CACHE_KEY + ":dataCenter_" + theDataCenterId;
    }

    private String cacheKeyWorkerId(Long theWorkerId) {
        return CACHE_KEY + ":worker_" + this.dataCenterId + "_" + theWorkerId;
    }
}

