package com.elitescloud.boot.jpa.config.entity;

import com.elitescloud.boot.jpa.common.EntityFilterHandler;
import org.hibernate.internal.SessionImpl;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;

import javax.persistence.EntityManagerFactory;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/10/16
 */
public class EntityFilterProvider implements InitializingBean {

    private final FactoryBean<EntityManagerFactory> entityManagerFactoryFactoryBean;
    private final EntityFilterHandler handler;

    public EntityFilterProvider(FactoryBean<EntityManagerFactory> entityManagerFactoryFactoryBean, EntityFilterHandler handler) {
        this.entityManagerFactoryFactoryBean = entityManagerFactoryFactoryBean;
        this.handler = handler;
    }


    @Override
    public void afterPropertiesSet() throws Exception {
        if (handler == null) {
            return;
        }
        if (entityManagerFactoryFactoryBean instanceof AbstractEntityManagerFactoryBean) {
            ((AbstractEntityManagerFactoryBean) entityManagerFactoryFactoryBean).setEntityManagerInitializer(entityManager -> {
                if (entityManager instanceof SessionImpl) {
                    SessionImpl session = (SessionImpl) entityManager;

                    handler.enableFilter(session);
                }
            });
        }
    }
}
