package com.elitescloud.boot.jpa.support.id.provider.snowflake;

import com.elitescloud.boot.jpa.support.id.provider.snowflake.assigner.SnowflakeWorkerAssigner;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.micro.Snowflake;
import com.elitescloud.boot.provider.CloudtIdCreator;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.InitializingBean;

/**
 * 雪花算法.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/8
 */
@Log4j2
public class SnowflakeProvider implements CloudtIdCreator, InitializingBean {

    private final SnowflakeWorkerAssigner workerAssigner;

    private Snowflake snowflake;

    public SnowflakeProvider(SnowflakeWorkerAssigner workerAssigner) {
        this.workerAssigner = workerAssigner;
    }

    @Override
    public Long create() {
        if (snowflake == null) {
            this.snowflake = buildSnowflake();
        }
        return snowflake.nextId();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.snowflake = buildSnowflake();
    }

    @Override
    public void refreshWorkerAssigner() {
        workerAssigner.refreshAlive();
    }

    @Override
    public void destroy() {
        workerAssigner.destroy();
    }

    private Snowflake buildSnowflake() {
        WorkerInfo workerInfo = workerAssigner.assign();
        return new Snowflake(workerInfo.getDataCenterId(), workerInfo.getWorkerId(), true, 5L, true);
    }
}
