/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.common;

import cn.hutool.core.util.ObjectUtil;
import com.blazebit.persistence.querydsl.BlazeJPAQuery;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.model.bo.TreeNodeBO;
import com.elitescloud.boot.model.entity.BaseTreeModel;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Assert;

public abstract class BaseTreeRepoProc<T extends BaseTreeModel>
extends BaseRepoProc<T> {
    private static final Logger log = LogManager.getLogger(BaseTreeRepoProc.class);
    protected final EntityPathBase<T> qModel;
    private Map<String, Path<?>> pathCache = new ConcurrentHashMap(16);
    private static final String PROPERTY_ID = "id";
    private static final String PROPERTY_LFT = "lft";
    private static final String PROPERTY_RGT = "rgt";
    private static final String PROPERTY_ROOT = "rootId";
    private static final String PROPERTY_DEPTH = "depth";
    private static final String PROPERTY_PID = "pId";
    private static final String PROPERTY_SORT_NO = "sortNo";

    public BaseTreeRepoProc(@NotNull EntityPathBase<T> qModel) {
        super(qModel);
        this.qModel = qModel;
    }

    public void saveTreeNode(@NotNull T node, Long parentId, Integer sortNo) {
        parentId = (Long)ObjectUtil.defaultIfNull((Object)parentId, (Object)-1L);
        Long leftNodeId = this.findLeftNodeId(parentId, sortNo);
        this.saveTreeNode(node, parentId, leftNodeId);
    }

    public void saveTreeNode(@NotNull T node, Long parentId, Long leftNodeId) {
        Assert.notNull((Object)node.getId(), (String)"\u8bf7\u5148\u4fdd\u5b58\u8282\u70b9\u4fe1\u606f");
        parentId = (Long)ObjectUtil.defaultIfNull((Object)parentId, (Object)-1L);
        if (node.getLft() == null) {
            this.addNode(node, parentId, leftNodeId);
            return;
        }
        if (parentId == -1L) {
            return;
        }
        if (leftNodeId != null && node.getLft().longValue() == leftNodeId.longValue()) {
            return;
        }
        if (leftNodeId == null && parentId.longValue() == node.getPId().longValue()) {
            return;
        }
        this.moveNode(node, parentId, leftNodeId);
    }

    public void moveNode(@NotNull T node, @NotNull Long parentNodeId, Long leftNodeId) {
        TreeNodeBO parentNode = null;
        TreeNodeBO leftNode = null;
        if (leftNodeId != null) {
            leftNode = this.getNodeInfo(leftNodeId);
            Assert.notNull((Object)leftNode, (String)"\u5de6\u8282\u70b9\u4e0d\u5b58\u5728");
        } else if (parentNodeId != -1L && (leftNode = this.getLastChildNode(parentNodeId)) == null) {
            parentNode = this.getNodeInfo(parentNodeId);
            Assert.notNull((Object)parentNode, (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        this.moveNode(node, parentNode, leftNode);
    }

    public boolean existsChildNode(@NotNull T node) {
        if (node.getLft() == null) {
            return false;
        }
        return node.getRgt() - node.getLft() > 1;
    }

    public Long findLeftNodeId(Long parentId, Integer sortNo) {
        parentId = (Long)ObjectUtil.defaultIfNull((Object)parentId, (Object)-1L);
        com.querydsl.core.types.Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(true, this.getPidPath(), parentId).and(sortNo != null, () -> this.getSortNoPath().lt((Number)sortNo)).build();
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.getIdPath()).from(this.qModel)).where(predicate)).orderBy(this.getLftPath().desc())).limit(1L)).fetchOne();
    }

    public Integer findMaxSortNo(Long parentId) {
        parentId = (Long)ObjectUtil.defaultIfNull((Object)parentId, (Object)-1L);
        Integer value = (Integer)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.getSortNoPath().max()).from(this.qModel)).where((com.querydsl.core.types.Predicate)this.getPidPath().eq((Object)parentId))).fetchOne();
        return (Integer)ObjectUtil.defaultIfNull((Object)value, (Object)0);
    }

    public void removeTreeNode(@NotNull T node) {
        if (node.getLft() == null) {
            return;
        }
        NumberPath<Integer> pathLeft = this.getLftPath();
        NumberPath<Integer> pathRight = this.getRgtPath();
        NumberPath<Long> pathRoot = this.getRootPath();
        this.jpaQueryFactory.update(this.qModel).set(pathLeft, (Expression)pathLeft.subtract((Number)2)).where(new com.querydsl.core.types.Predicate[]{pathLeft.gt((Number)node.getLft()).and((com.querydsl.core.types.Predicate)pathRoot.eq((Object)node.getRootId()))}).execute();
        this.jpaQueryFactory.update(this.qModel).set(pathRight, (Expression)pathRight.subtract((Number)2)).where(new com.querydsl.core.types.Predicate[]{pathRight.gt((Number)node.getRgt()).and((com.querydsl.core.types.Predicate)pathRoot.eq((Object)node.getRootId()))}).execute();
        node.setLft(null);
        node.setRgt(null);
        node.setPId(null);
        node.setRootId(null);
        node.setDepth(null);
    }

    public <R> List<R> getTree(Long pId, com.querydsl.core.types.Predicate predicate, Predicate<T> nodePredicate, Function<T, R> nodeMapper) {
        List<T> treeNodeList;
        com.querydsl.core.types.Predicate condition = null;
        if (pId != null) {
            TreeNodeBO nodeInfo = this.getNodeInfo(pId);
            Assert.notNull((Object)nodeInfo, (String)("\u8282\u70b9[" + pId + "]\u4e0d\u5b58\u5728"));
            condition = this.getRootPath().eq((Object)nodeInfo.getRootId()).and((com.querydsl.core.types.Predicate)this.getLftPath().goe((Number)nodeInfo.getLft())).and((com.querydsl.core.types.Predicate)this.getRgtPath().loe((Number)nodeInfo.getRgt()));
        }
        if (predicate != null) {
            condition = this.andPredicate(condition, predicate);
        }
        if ((treeNodeList = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qModel).from(this.qModel)).where(condition)).fetch()).isEmpty()) {
            return treeNodeList;
        }
        treeNodeList = this.filterTreeNode(treeNodeList, nodePredicate);
        if (nodeMapper == null) {
            return treeNodeList;
        }
        return treeNodeList.stream().map(nodeMapper).collect(Collectors.toList());
    }

    public void rebuildTree(Long nodeId, @NotNull Function<T, Long> getParentId) {
        Long rootId = this.clearNodeInfo(nodeId);
        log.info("\u91cd\u6784\u6811\uff1a{}", (Object)rootId);
        Map<Long, List<T>> dataMaps = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qModel).from(this.qModel)).where(rootId == null ? null : this.getRootPath().eq((Object)rootId))).fetch().stream().collect(Collectors.groupingBy(t -> {
            Long pId = (Long)getParentId.apply(t);
            return (Long)ObjectUtil.defaultIfNull((Object)pId, (Object)-1L);
        }));
        if (dataMaps.isEmpty()) {
            return;
        }
        List roots = dataMaps.getOrDefault(-1L, Collections.emptyList());
        Assert.notEmpty(roots, (String)"\u672a\u67e5\u8be2\u5230\u6839\u8282\u70b9\u6570\u636e");
        this.addNodeWithChildren(roots, -1L, dataMaps);
    }

    public List<Long> getIdByPid(long pid) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.getIdPath()).from(this.qModel)).where((com.querydsl.core.types.Predicate)this.getPidPath().eq((Object)pid))).fetch();
    }

    public List<Long> getChildrenIdByPid(long pid) {
        TreeNodeBO nodeInfo = this.getNodeInfo(pid);
        if (nodeInfo == null || nodeInfo.getLft() == null) {
            return Collections.emptyList();
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.getIdPath()).from(this.qModel)).where((com.querydsl.core.types.Predicate)this.getLftPath().gt((Number)nodeInfo.getLft()).and((com.querydsl.core.types.Predicate)this.getRgtPath().lt((Number)nodeInfo.getRgt())).and((com.querydsl.core.types.Predicate)this.getRootPath().eq((Object)nodeInfo.getRootId())))).fetch();
    }

    protected BooleanExpression predicateForParents(@NotNull Long id) {
        TreeNodeBO nodeInfo = this.getNodeInfo(id);
        Assert.notNull((Object)nodeInfo, (String)("\u8282\u70b9[" + id + "]\u4e0d\u5b58\u5728"));
        return this.getRootPath().eq((Object)nodeInfo.getRootId()).and((com.querydsl.core.types.Predicate)this.getLftPath().loe((Number)nodeInfo.getLft())).and((com.querydsl.core.types.Predicate)this.getRgtPath().goe((Number)nodeInfo.getRgt()));
    }

    protected BooleanExpression predicateForChildren(@NotNull Long id) {
        TreeNodeBO nodeInfo = this.getNodeInfo(id);
        Assert.notNull((Object)nodeInfo, (String)("\u8282\u70b9[" + id + "]\u4e0d\u5b58\u5728"));
        return this.getRootPath().eq((Object)nodeInfo.getRootId()).and((com.querydsl.core.types.Predicate)this.getLftPath().goe((Number)nodeInfo.getLft())).and((com.querydsl.core.types.Predicate)this.getRgtPath().loe((Number)nodeInfo.getRgt()));
    }

    protected boolean hasChildren(Integer lfg, Integer rgt) {
        if (lfg == null || rgt == null) {
            return false;
        }
        return rgt - lfg > 1;
    }

    protected Map<Long, Long> filterParentId(@NotNull EntityPathBase<T> parentModel, com.querydsl.core.types.Predicate parentPredicate, com.querydsl.core.types.Predicate predicate) {
        JPQLQuery selectParentId = (JPQLQuery)((JPQLQuery)((JPQLQuery)JPAExpressions.select((Expression)Expressions.numberPath(Long.class, parentModel, (String)PROPERTY_ID)).from(new EntityPath[]{parentModel}).where(new com.querydsl.core.types.Predicate[]{Expressions.numberPath(Long.class, parentModel, (String)PROPERTY_ROOT).eq(this.getRootPath()).and((com.querydsl.core.types.Predicate)Expressions.numberPath(Long.class, parentModel, (String)PROPERTY_LFT).loe(this.getLftPath())).and((com.querydsl.core.types.Predicate)Expressions.numberPath(Long.class, parentModel, (String)PROPERTY_RGT).goe(this.getRgtPath())).and(parentPredicate)})).orderBy(new OrderSpecifier[]{Expressions.numberPath(Long.class, parentModel, (String)PROPERTY_LFT).desc()})).limit(1L);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.getIdPath(), selectParentId}).from(this.qModel)).where(predicate);
        BlazeJPAQuery blazeJpaQuery = new BlazeJPAQuery(this.entityManager, jpaQuery.getMetadata(), this.criteriaBuilderFactory);
        return blazeJpaQuery.fetch().stream().collect(Collectors.toMap(t -> (Long)t.get(0, Long.class), t -> (Long)ObjectUtil.defaultIfNull((Object)((Long)t.get(1, Long.class)), (Object)-1L), (t1, t2) -> t1));
    }

    private List<T> filterTreeNode(List<T> nodeList, Predicate<T> nodePredicate) {
        ArrayList filterNodes = new ArrayList(nodeList.size());
        while (true) {
            ArrayList<T> candidateNodes = new ArrayList<T>(nodeList.size());
            ArrayList<BaseTreeModel> excludeNodes = new ArrayList<BaseTreeModel>(nodeList.size());
            block1: for (BaseTreeModel t : nodeList) {
                for (BaseTreeModel filterNode : filterNodes) {
                    if (filterNode.getRootId().longValue() != t.getRootId().longValue() || t.getLft() <= filterNode.getLft() || t.getRgt() >= filterNode.getRgt()) continue;
                    excludeNodes.add(t);
                    continue block1;
                }
                if (nodePredicate == null || nodePredicate.test(t)) {
                    candidateNodes.add(t);
                    continue;
                }
                excludeNodes.add(t);
            }
            nodeList = candidateNodes;
            if (excludeNodes.isEmpty()) break;
            filterNodes.addAll(excludeNodes);
        }
        return nodeList;
    }

    private void moveNode(@NotNull T node, TreeNodeBO parentNode, TreeNodeBO leftNode) {
        if (leftNode != null) {
            this.moveNodeByLeftNode(node, leftNode);
            return;
        }
        if (parentNode != null) {
            this.moveNodeByParentNode(node, parentNode);
            return;
        }
        this.moveNodeByRoot(node);
    }

    private void moveNodeByLeftNode(@NotNull T node, @NotNull TreeNodeBO leftNode) {
        if (node.getId().longValue() == leftNode.getId().longValue()) {
            log.warn("\u6811\u8282\u70b9\u79fb\u52a8\u5931\u8d25\uff0c\u8981\u79fb\u52a8\u7684\u8282\u70b9\u4e0e\u5de6\u8282\u70b9\u76f8\u540c");
            return;
        }
        if (node.getPId().longValue() == leftNode.getPid().longValue() && node.getLft() - leftNode.getRgt() == 1) {
            return;
        }
        this.removeTreeNode(node);
        this.addNode(node, leftNode.getPid(), leftNode.getId());
    }

    private void moveNodeByParentNode(@NotNull T node, @NotNull TreeNodeBO parentNode) {
        if (node.getPId().longValue() == parentNode.getId().longValue()) {
            log.warn("\u5df2\u5728\u6307\u5b9a\u5b50\u8282\u70b9\u4e0b\uff0c\u65e0\u9700\u79fb\u52a8");
            return;
        }
        this.removeTreeNode(node);
        this.addNode(node, parentNode.getId(), null);
    }

    private void moveNodeByRoot(@NotNull T node) {
        this.removeTreeNode(node);
        this.addRootNode(node);
    }

    private void addRootNode(@NotNull T node) {
        node.setLft(Integer.valueOf(1));
        node.setRgt(Integer.valueOf(2));
        node.setPId(Long.valueOf(-1L));
        node.setRootId(node.getId());
        node.setDepth(Integer.valueOf(1));
        this.jpaQueryFactory.update(this.qModel).set(this.getLftPath(), (Object)node.getLft()).set(this.getRgtPath(), (Object)node.getRgt()).set(this.getPidPath(), (Object)-1L).set(this.getRootPath(), (Object)node.getRootId()).set(this.getDepthPath(), (Object)node.getDepth()).where(new com.querydsl.core.types.Predicate[]{this.getIdPath().eq((Object)node.getId())}).execute();
    }

    private void addNode(@NotNull T node, @NotNull Long parentId, Long leftNodeId) {
        if (parentId == -1L) {
            this.addRootNode(node);
            return;
        }
        TreeNodeBO parentNode = null;
        TreeNodeBO leftNode = null;
        Set<Long> tempIds = leftNodeId == null ? Set.of(parentId) : Set.of(parentId, leftNodeId);
        Map<Long, TreeNodeBO> nodes = this.getNodeInfo(tempIds);
        parentNode = nodes.get(parentId);
        Assert.notNull((Object)parentNode, (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728");
        Assert.notNull((Object)parentNode.getLft(), (String)"\u7236\u8282\u70b9\u672a\u521d\u59cb\u5316");
        if (parentNode.getRgt() - parentNode.getLft() > 1 && leftNodeId != null) {
            leftNode = nodes.get(leftNodeId);
            Assert.notNull((Object)leftNode, (String)"\u5de6\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        this.addChildNode(node, parentNode, leftNode);
    }

    private void addChildNode(@NotNull T node, @NotNull TreeNodeBO parentNode, TreeNodeBO leftNode) {
        int lft;
        if (parentNode.getRgt() - parentNode.getLft() > 1 && leftNode == null) {
            leftNode = this.getLastChildNode(parentNode.getId());
            Assert.notNull((Object)leftNode, (String)"\u83b7\u53d6\u5de6\u8282\u70b9\u5931\u8d25");
        }
        NumberPath<Long> pathRoot = this.getRootPath();
        NumberPath<Integer> pathLft = this.getLftPath();
        NumberPath<Integer> pathRgt = this.getRgtPath();
        if (leftNode == null) {
            lft = parentNode.getRgt();
            this.jpaQueryFactory.update(this.qModel).set(pathLft, (Expression)pathLft.add((Number)2)).where(new com.querydsl.core.types.Predicate[]{pathRoot.eq((Object)parentNode.getRootId()).and((com.querydsl.core.types.Predicate)pathLft.gt((Number)lft))}).execute();
            this.jpaQueryFactory.update(this.qModel).set(pathRgt, (Expression)pathRgt.add((Number)2)).where(new com.querydsl.core.types.Predicate[]{pathRoot.eq((Object)parentNode.getRootId()).and((com.querydsl.core.types.Predicate)pathRgt.goe((Number)lft))}).execute();
        } else {
            lft = leftNode.getRgt() + 1;
            this.jpaQueryFactory.update(this.qModel).set(pathLft, (Expression)pathLft.add((Number)2)).where(new com.querydsl.core.types.Predicate[]{pathRoot.eq((Object)parentNode.getRootId()).and((com.querydsl.core.types.Predicate)pathLft.goe((Number)lft))}).execute();
            this.jpaQueryFactory.update(this.qModel).set(pathRgt, (Expression)pathRgt.add((Number)2)).where(new com.querydsl.core.types.Predicate[]{pathRoot.eq((Object)parentNode.getRootId()).and((com.querydsl.core.types.Predicate)pathRgt.goe((Number)lft))}).execute();
        }
        int rgt = lft + 1;
        node.setLft(Integer.valueOf(lft));
        node.setRgt(Integer.valueOf(rgt));
        node.setRootId(parentNode.getRootId());
        node.setPId(parentNode.getId());
        node.setDepth(Integer.valueOf(parentNode.getDepth() + 1));
        this.jpaQueryFactory.update(this.qModel).set(pathLft, (Object)node.getLft()).set(pathRgt, (Object)node.getRgt()).set(pathRoot, (Object)node.getRootId()).set(this.getPidPath(), (Object)parentNode.getId()).set(this.getDepthPath(), (Object)node.getDepth()).where(new com.querydsl.core.types.Predicate[]{this.getIdPath().eq((Object)node.getId())}).execute();
    }

    private void addNodeWithChildren(List<T> nodes, Long pid, Map<Long, List<T>> nodesMap) {
        Long tempLeftNodeId = null;
        int sortNo = 1;
        for (BaseTreeModel node : nodes) {
            if (node.getSortNo() == null) {
                node.setSortNo(Integer.valueOf(1));
            }
            this.addNode(node, pid, tempLeftNodeId);
            List children = nodesMap.getOrDefault(node.getId(), Collections.emptyList());
            if (!children.isEmpty()) {
                this.addNodeWithChildren(children, node.getId(), nodesMap);
            }
            tempLeftNodeId = node.getId();
            ++sortNo;
        }
    }

    private Long clearNodeInfo(Long nodeId) {
        if (nodeId == null) {
            this.jpaQueryFactory.update(this.qModel).setNull(this.getPidPath()).setNull(this.getLftPath()).setNull(this.getRgtPath()).execute();
            return null;
        }
        Long rootId = (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.getRootPath()).from(this.qModel)).where((com.querydsl.core.types.Predicate)this.getIdPath().eq((Object)nodeId))).limit(1L)).fetchOne();
        Assert.notNull((Object)rootId, (String)("\u672a\u77e5\u8282\u70b9[" + nodeId + "]\u6240\u5728\u6811"));
        this.jpaQueryFactory.update(this.qModel).setNull(this.getPidPath()).setNull(this.getLftPath()).setNull(this.getRgtPath()).where(new com.querydsl.core.types.Predicate[]{this.getRootPath().eq((Object)rootId)}).execute();
        return rootId;
    }

    private TreeNodeBO getNodeInfo(Long id) {
        if (id == -1L) {
            return null;
        }
        return (TreeNodeBO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanOfTreeNodeBO()).from(this.qModel)).where((com.querydsl.core.types.Predicate)this.getIdPath().eq((Object)id))).limit(1L)).fetchOne();
    }

    private Map<Long, TreeNodeBO> getNodeInfo(Set<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanOfTreeNodeBO()).from(this.qModel)).where((com.querydsl.core.types.Predicate)this.getIdPath().in(ids))).fetch().stream().collect(Collectors.toMap(TreeNodeBO::getId, t -> t, (t1, t2) -> t1));
    }

    private TreeNodeBO getLastChildNode(Long pId) {
        if (pId == -1L) {
            return null;
        }
        return (TreeNodeBO)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanOfTreeNodeBO()).from(this.qModel)).where((com.querydsl.core.types.Predicate)this.getPidPath().eq((Object)pId))).orderBy(this.getRgtPath().desc())).limit(1L)).fetchOne();
    }

    private TreeNodeBO getFirstChildNode(Long pId) {
        if (pId == -1L) {
            return null;
        }
        return (TreeNodeBO)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanOfTreeNodeBO()).from(this.qModel)).where((com.querydsl.core.types.Predicate)this.getPidPath().eq((Object)pId))).orderBy(this.getLftPath().asc())).limit(1L)).fetchOne();
    }

    private QBean<TreeNodeBO> qBeanOfTreeNodeBO() {
        return Projections.bean(TreeNodeBO.class, (Expression[])new Expression[]{this.getIdPath(), this.getPidPath().as("pid"), this.getRootPath(), this.getLftPath(), this.getRgtPath(), this.getDepthPath()});
    }

    private NumberPath<Integer> getLftPath() {
        return (NumberPath)this.pathCache.computeIfAbsent(PROPERTY_LFT, p -> Expressions.numberPath(Integer.class, this.qModel, (String)p));
    }

    private NumberPath<Integer> getRgtPath() {
        return (NumberPath)this.pathCache.computeIfAbsent(PROPERTY_RGT, p -> Expressions.numberPath(Integer.class, this.qModel, (String)p));
    }

    private NumberPath<Long> getRootPath() {
        return (NumberPath)this.pathCache.computeIfAbsent(PROPERTY_ROOT, p -> Expressions.numberPath(Long.class, this.qModel, (String)p));
    }

    private NumberPath<Integer> getDepthPath() {
        return (NumberPath)this.pathCache.computeIfAbsent(PROPERTY_DEPTH, p -> Expressions.numberPath(Integer.class, this.qModel, (String)p));
    }

    private NumberPath<Long> getPidPath() {
        return (NumberPath)this.pathCache.computeIfAbsent(PROPERTY_PID, p -> Expressions.numberPath(Long.class, this.qModel, (String)p));
    }

    private NumberPath<Integer> getSortNoPath() {
        return (NumberPath)this.pathCache.computeIfAbsent(PROPERTY_SORT_NO, p -> Expressions.numberPath(Integer.class, this.qModel, (String)p));
    }
}

