package com.elitescloud.boot.jpa.support.id.provider.snowflake.assigner;

import com.elitescloud.boot.jpa.support.id.config.IdProperties;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.WorkerInfo;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.micro.Snowflake;
import org.springframework.util.Assert;

/**
 * 手动指定.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/7
 */
public class ManualSnowflakeWorkerAssigner extends AbstractSnowflakeWorkerAssigner {

    private final IdProperties idProperties;

    public ManualSnowflakeWorkerAssigner(IdProperties idProperties) {
        this.idProperties = idProperties;
    }

    @Override
    protected WorkerInfo distribute() {
        var snowflake = idProperties.getSnowflake();
        Long dataCenterId = snowflake.getDataCenterId();
        Long workerId = snowflake.getWorkerId();

        Assert.notNull(dataCenterId, "dataCenterId未设置");
        Assert.isTrue(dataCenterId > 0 && dataCenterId < Snowflake.getMaxDataCenterId(), "dataCenterId取值范围为1~" + Snowflake.getMaxDataCenterId());

        Assert.notNull(workerId, "workerId未设置");
        Assert.isTrue(workerId > 0 && workerId < Snowflake.getMaxWorkerId(), "workerId取值范围为1~" + Snowflake.getMaxWorkerId());

        return new WorkerInfo(dataCenterId, workerId);
    }

    @Override
    public void refreshAlive() {
        // nothing to do
    }

    @Override
    public void destroy() {
        // nothing to do
    }
}
