package org.hibernate.annotations;

import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * <p>
 * 功能说明:覆盖源码 支持继承
 *  具体源码参见 org.hibernate.annotations#Where
 * </p>
 *
 * @author roman
 * @since 2022/2/23 5:07 PM
 */
@Inherited
@Target({TYPE, METHOD, FIELD})
@Retention(RUNTIME)
public @interface Where {
    /**
     * The where-clause predicate.
     */
    String clause();
}
