package com.elitescloud.boot.jpa;

import com.elitescloud.boot.exception.CustomExceptionTranslate;
import com.elitescloud.boot.jpa.config.HibernateConfig;
import com.elitescloud.boot.jpa.config.auditing.AuditConfig;
import com.elitescloud.boot.jpa.config.entity.EntityConfig;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.lang.NonNull;

/**
 * JPA自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/13/2023
 */
@EnableConfigurationProperties({CloudtJpaProperties.class})
@Import({
        HibernateConfig.class, EntityConfig.class, AuditConfig.class
})
@EntityScan(basePackages = {"com.elitescloud", "com.elitesland"})
@EnableJpaRepositories(basePackages = {"com.elitescloud", "com.elitesland"})
public class CloudtJpaAutoConfiguration {

    @Bean
    public CustomExceptionTranslate customExceptionTranslateJpa() {
        return new CustomExceptionTranslate() {
            @Override
            public boolean support(@NonNull Throwable e) {
                return e instanceof DataAccessResourceFailureException;
            }

            @Override
            public ApiResult<String> translate(@NonNull Throwable e) {
                return ApiResult.fail(ApiCode.DATABASE_EXCEPTION, "数据库访问异常");
            }
        };
    }
}
