package com.elitescloud.boot.jpa;

import com.elitescloud.boot.condition.ConditionalOnTenant;
import com.elitescloud.boot.jpa.config.tenant.TenantEntityFilterHandler;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

/**
 * 租户的jpa自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/23/2023
 */
@ConditionalOnTenant
class CloudtJpaTenantAutoConfiguration {

    /**
     * 数据过滤
     *
     * @return
     */
    @Bean
    @ConditionalOnTenant(isolateStrategy = TenantIsolateStrategy.FIELD)
    @Primary
    public TenantEntityFilterHandler hibernateDataFilter(TenantClientProvider clientProvider,
                                                         ObjectProvider<UserDetailProvider> userProvider) {
        return new TenantEntityFilterHandler(userProvider.getIfAvailable(), clientProvider);
    }
}
