package com.elitescloud.boot.jpa.support.id.provider.uidgenerator.worker;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.jpa.support.id.config.IdProperties;

/**
 * 手动指定WorkerId.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/9
 */
public class ManualWorkerIdAssigner extends AbstractWorkerIdAssigner {

    private final IdProperties idProperties;

    public ManualWorkerIdAssigner(IdProperties idProperties) {
        this.idProperties = idProperties;
    }

    @Override
    public void refreshAlive() {
        // nothing to do
    }

    @Override
    public void destroy() {
        // nothing to do
    }

    @Override
    public long assignWorkerId() {
        long workerId = ObjectUtil.defaultIfNull(idProperties.getUid().getWorkerId(), 1L);
        long max = super.maxWorkerId(idProperties);
        if (workerId < 0 || workerId > max) {
            throw new IllegalArgumentException("workerId现在取值为0至" + max);
        }
        return idProperties.getUid().getWorkerId();
    }
}
