/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.util;

import java.io.File;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.CamelCaseToUnderscoresNamingStrategy;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQL57Dialect;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.schema.spi.SchemaFilter;
import org.hibernate.tool.schema.spi.SchemaFilterProvider;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.orm.jpa.hibernate.SpringImplicitNamingStrategy;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;

public class DataBaseExportUtil {
    private final Set<String> entityPackages = new HashSet<String>(4);
    private boolean format = true;
    private boolean createBeforeDrop = false;
    private Class<? extends Dialect> dialect = MySQL57Dialect.class;
    private File outputFile;
    private final Set<String> entityClassNames = new HashSet<String>(128);

    protected DataBaseExportUtil() {
    }

    public static DataBaseExportUtil instance() {
        return new DataBaseExportUtil();
    }

    public DataBaseExportUtil entityPackage(String entityPackage) {
        if (StringUtils.hasText((String)entityPackage)) {
            this.entityPackages.add(entityPackage);
        }
        return this;
    }

    public DataBaseExportUtil format(boolean format) {
        this.format = format;
        return this;
    }

    public DataBaseExportUtil createBeforeDrop(boolean createBeforeDrop) {
        this.createBeforeDrop = createBeforeDrop;
        return this;
    }

    public DataBaseExportUtil dialect(Class<? extends Dialect> dialect) {
        this.dialect = dialect;
        return this;
    }

    public DataBaseExportUtil outputFile(File outputFile) {
        this.outputFile = outputFile;
        return this;
    }

    public DataBaseExportUtil entityClass(Class<?> ... clazz) {
        for (Class<?> cla : clazz) {
            this.entityClassNames.add(cla.getName());
        }
        return this;
    }

    public void exportDdl() {
        this.scanEntity();
        if (this.entityClassNames.isEmpty()) {
            System.err.println("\u8bf7\u5148\u8bbe\u7f6e\u8981\u5bfc\u51fa\u7684\u5b9e\u4f53");
            return;
        }
        this.execExport();
    }

    private void execExport() {
        BootstrapServiceRegistry bootstrapServiceRegistry = new BootstrapServiceRegistryBuilder().build();
        StandardServiceRegistryBuilder ssrBuilder = new StandardServiceRegistryBuilder(bootstrapServiceRegistry).applySetting("hibernate.dialect", (Object)this.dialect.getName()).applySetting("hibernate.implicit_naming_strategy", (Object)SpringImplicitNamingStrategy.class.getName()).applySetting("hibernate.physical_naming_strategy", (Object)CamelCaseToUnderscoresNamingStrategy.class.getName()).applySetting("hibernate.hbm2ddl.schema_filter_provider", (Object)new CustomSchemaFilterProvider());
        StandardServiceRegistry serviceRegistry = ssrBuilder.build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
        for (String entityClassName : this.entityClassNames) {
            metadataSources.addAnnotatedClassName(entityClassName);
        }
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder();
        Metadata metadata = metadataBuilder.build();
        SchemaExport export = new SchemaExport();
        export.setFormat(this.format);
        export.setOverrideOutputFileContent();
        EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.STDOUT);
        if (this.outputFile != null) {
            export.setOutputFile(this.outputFile.getAbsolutePath());
            targetTypes.add(TargetType.SCRIPT);
        }
        SchemaExport.Action action = this.createBeforeDrop ? SchemaExport.Action.BOTH : SchemaExport.Action.CREATE;
        export.execute(targetTypes, action, metadata);
    }

    private void scanEntity() {
        CustomClassPathScanningCandidateComponentProvider componentProvider = new CustomClassPathScanningCandidateComponentProvider();
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(javax.persistence.Table.class));
        for (String basePackage : this.entityPackages) {
            Set beanDefinitions = componentProvider.findCandidateComponents(basePackage.replace(".", "/"));
            this.entityClassNames.addAll(beanDefinitions.stream().map(BeanDefinition::getBeanClassName).collect(Collectors.toList()));
        }
    }

    static class CustomSchemaFilter
    implements SchemaFilter {
        private final Set<String> excludeTableNames = new HashSet<String>();

        public CustomSchemaFilter() {
            this.excludeTableNames.add("values_entity");
        }

        public boolean includeNamespace(Namespace namespace) {
            return true;
        }

        public boolean includeTable(Table table) {
            return !this.excludeTableNames.contains(table.getName());
        }

        public boolean includeSequence(Sequence sequence) {
            return true;
        }
    }

    static class CustomSchemaFilterProvider
    implements SchemaFilterProvider {
        private static final SchemaFilter INSTANCE = new CustomSchemaFilter();

        CustomSchemaFilterProvider() {
        }

        public SchemaFilter getCreateFilter() {
            return INSTANCE;
        }

        public SchemaFilter getDropFilter() {
            return INSTANCE;
        }

        public SchemaFilter getMigrateFilter() {
            return INSTANCE;
        }

        public SchemaFilter getValidateFilter() {
            return INSTANCE;
        }
    }

    static class CustomClassPathScanningCandidateComponentProvider
    extends ClassPathScanningCandidateComponentProvider {
        public CustomClassPathScanningCandidateComponentProvider() {
            super(false);
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return true;
        }
    }
}

