package com.elitescloud.boot.jpa;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 数据持久化相关属性配置.
 * <p>
 * 后期考虑该属性单独到cloudt-boot-starter-data模块，不仅仅是对jpa的支持
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/8
 */
@ConfigurationProperties(prefix = CloudtDataProperties.CONFIG_PREFIX)
public class CloudtDataProperties {
    public static final String CONFIG_PREFIX = "elitesland.data";

    /**
     * 审计者类型
     */
    private AuditorType auditorType = AuditorType.FULL_NAME;

    public AuditorType getAuditorType() {
        return auditorType;
    }

    public void setAuditorType(AuditorType auditorType) {
        this.auditorType = auditorType;
    }

    public enum AuditorType {
        /**
         * 无
         */
        NONE,
        /**
         * 登录号
         */
        USER_NAME,
        /**
         * 姓名
         */
        FULL_NAME,
        /**
         * 自定义
         */
        CUSTOM
    }
}
