/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa;

import cn.hutool.core.util.RuntimeUtil;
import com.elitescloud.boot.jpa.support.id.common.WorkerAssignerType;
import com.elitescloud.boot.jpa.support.id.config.IdProperties;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.config.SnowflakeConfig;
import com.elitescloud.boot.jpa.support.id.provider.uidgenerator.config.UidConfig;
import com.elitescloud.boot.provider.CloudtIdCreator;
import com.elitescloud.cloudt.core.provider.IdGeneratorProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.util.Assert;

@EnableConfigurationProperties(value={IdProperties.class})
@Import(value={SnowflakeConfig.class, UidConfig.class, CloudtWorkerConfig.class})
class CloudtIdGeneratorAutoConfiguration {
    private static final Logger log = LogManager.getLogger(CloudtIdGeneratorAutoConfiguration.class);

    public CloudtIdGeneratorAutoConfiguration(IdProperties idProperties) {
        log.info("ID\u751f\u6210\u5668\u7c7b\u578b\uff1a{}", (Object)idProperties.getGenType());
    }

    @Bean
    public IdGeneratorProvider idGeneratorProvider() {
        return new IdGeneratorProvider();
    }

    static class CloudtWorkerConfig
    implements SchedulingConfigurer,
    InitializingBean {
        private final IdProperties idProperties;
        private CloudtIdCreator cloudtIdGenerator;

        public CloudtWorkerConfig(IdProperties idProperties) {
            this.idProperties = idProperties;
        }

        public void afterPropertiesSet() throws Exception {
            RuntimeUtil.addShutdownHook(() -> ((CloudtIdCreator)this.cloudtIdGenerator).destroy());
        }

        public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
            if (this.idProperties.getAssignerType() == WorkerAssignerType.MANUAL) {
                return;
            }
            Assert.isTrue((this.idProperties.getAlive() != null && this.idProperties.getAlive().toSeconds() > 0L ? 1 : 0) != 0, (String)"alive\u8bbe\u7f6e\u6709\u8bef");
            Assert.isTrue((this.idProperties.getHeartBeat() != null && this.idProperties.getHeartBeat().toSeconds() < this.idProperties.getAlive().toSeconds() ? 1 : 0) != 0, (String)"heartBeat\u8bbe\u7f6e\u6709\u8bef");
            taskRegistrar.addFixedDelayTask(() -> {
                try {
                    this.cloudtIdGenerator.refreshWorkerAssigner();
                }
                catch (Exception e) {
                    log.error("\u5237\u65b0WorkerAssigner\u5931\u8d25\uff1a", (Throwable)e);
                }
            }, this.idProperties.getHeartBeat().toMillis());
        }

        @Autowired
        public void setCloudtIdGenerator(CloudtIdCreator cloudtIdGenerator) {
            this.cloudtIdGenerator = cloudtIdGenerator;
        }
    }
}

