/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.support.id.provider.snowflake.assigner;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import com.elitescloud.boot.jpa.support.id.config.GenType;
import com.elitescloud.boot.jpa.support.id.config.IdProperties;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.WorkerInfo;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.assigner.AbstractSnowflakeWorkerAssigner;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.micro.Snowflake;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class DatabaseSnowflakeWorkerAssigner
extends AbstractSnowflakeWorkerAssigner {
    private static final Logger log = LogManager.getLogger(DatabaseSnowflakeWorkerAssigner.class);
    private static final String SQL_INSERT = "insert into sys_id_generator(id, gen_type, data_center_name, data_center_id, worker_id, instance_ip, create_time, modify_time) value (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_QUERY_DATA_CENTER_ID = "select data_center_id from sys_id_generator where data_center_name = ? order by create_time asc";
    private static final String SQL_REFRESH = "update sys_id_generator set modify_time = ? where data_center_id = ? and worker_id = ?";
    private static final String SQL_DELETE_EXPIRE = "delete from sys_id_generator where modify_time < ?";
    private static final String SQL_DESTROY = "delete from sys_id_generator where data_center_id = ? and worker_id = ?";
    private final String dataCenterName;
    private final IdProperties idProperties;
    private final JdbcTemplate jdbcTemplate;
    private Long dataCenterId;
    private Long workerId;

    public DatabaseSnowflakeWorkerAssigner(String dataCenterName, IdProperties idProperties, JdbcTemplate jdbcTemplate) {
        this.dataCenterName = dataCenterName;
        this.idProperties = idProperties;
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    protected WorkerInfo distribute() {
        this.generateDataCenterId();
        this.generateWorkerId();
        return new WorkerInfo(this.dataCenterId, this.workerId);
    }

    @Override
    public void refreshAlive() {
        LocalDateTime now = LocalDateTime.now();
        try {
            this.jdbcTemplate.batchUpdate(SQL_REFRESH, Arrays.asList({now, this.dataCenterId, this.workerId}, {now, this.dataCenterId, -1}));
            this.jdbcTemplate.update(SQL_DELETE_EXPIRE, new Object[]{now.minusMinutes(this.idProperties.getAlive().toMinutes())});
        }
        catch (DataAccessException e) {
            log.error("\u5237\u65b0IdGenerator WorkerId\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    @Override
    public void destroy() {
        try {
            this.jdbcTemplate.update(SQL_DESTROY, new Object[]{this.dataCenterId, this.workerId});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void generateDataCenterId() {
        this.dataCenterId = this.existsDataCenterId();
        if (this.dataCenterId != null) {
            return;
        }
        String ip = super.getIp();
        long max = Snowflake.getMaxDataCenterId();
        for (long temp = 0L; temp < max; ++temp) {
            LocalDateTime now = LocalDateTime.now();
            try {
                this.jdbcTemplate.update(SQL_INSERT, new Object[]{IdUtil.fastSimpleUUID(), GenType.SNOWFLAKE.name(), this.dataCenterName, temp, -1, ip, now, now});
                this.dataCenterId = temp;
                return;
            }
            catch (DataAccessException e) {
                this.dataCenterId = this.existsDataCenterId();
                if (this.dataCenterId == null) continue;
                return;
            }
        }
        throw new IllegalStateException("dataCenterId\u8d85\u8fc7\u9650\u5236" + max);
    }

    private void generateWorkerId() {
        long max = Snowflake.getMaxWorkerId();
        String ip = super.getIp();
        for (long temp = 0L; temp < max; ++temp) {
            LocalDateTime now = LocalDateTime.now();
            try {
                this.jdbcTemplate.update(SQL_INSERT, new Object[]{IdUtil.fastSimpleUUID(), GenType.SNOWFLAKE.name(), this.dataCenterName, this.dataCenterId, temp, ip, now, now});
                this.workerId = temp;
                return;
            }
            catch (DataAccessException e) {
                continue;
            }
        }
        throw new IllegalStateException("workerId\u8d85\u8fc7\u9650\u5236" + max);
    }

    private Long existsDataCenterId() {
        List dataCenterIdList = this.jdbcTemplate.queryForList(SQL_QUERY_DATA_CENTER_ID, Long.class, new Object[]{this.dataCenterName});
        if (CollUtil.isNotEmpty((Collection)dataCenterIdList)) {
            return (Long)dataCenterIdList.get(0);
        }
        return null;
    }
}

