package com.elitescloud.boot.jpa.config.tenant;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.tenant.client.common.AbstractTenantDatasourceProvider;
import com.elitescloud.cloudt.context.util.database.SqlUtil;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import lombok.extern.log4j.Log4j2;
import org.hibernate.engine.jdbc.connections.spi.AbstractDataSourceBasedMultiTenantConnectionProviderImpl;
import org.springframework.orm.jpa.vendor.Database;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;

/**
 * 租户数据源提供.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/25
 */
@Log4j2
public class HibernateTenantDatasourceProvider extends AbstractDataSourceBasedMultiTenantConnectionProviderImpl {

    private static final long serialVersionUID = -3009600657851822507L;

    public HibernateTenantDatasourceProvider() {
    }

    @Override
    public Connection getConnection(String tenantIdentifier) throws SQLException {
        Connection connection = super.getConnection(tenantIdentifier);
        String schema = getTenantSchema(tenantIdentifier);
        Database database = AbstractTenantDatasourceProvider.getDatabaseType();
        log.debug("use schema '{}' for tenant '{}'", schema, tenantIdentifier);

        String command = SqlUtil.generateSwitchSchemaSql(database, schema);
        try (var statement = connection.createStatement()) {
            statement.execute(command);
        }
        return connection;
    }

    @Override
    protected DataSource selectAnyDataSource() {
        return AbstractTenantDatasourceProvider.getDefaultDataSource();
    }

    @Override
    protected DataSource selectDataSource(String tenantIdentifier) {
        return AbstractTenantDatasourceProvider.getDefaultDataSource();
    }

    private String getTenantSchema(String tenantIdentifier) {
        if (TenantConstant.DEFAULT_TENANT_ID.toString().equals(tenantIdentifier)) {
            // 默认租户
            return AbstractTenantDatasourceProvider.getDefaultSchema();
        }

        // 从上下文获取租户
        SysTenantDTO tenant = AbstractTenantDatasourceProvider.detectedTenant();
        if (tenant == null) {
            return AbstractTenantDatasourceProvider.getDefaultSchema();
        }

        String prefix = CharSequenceUtil.isBlank(AbstractTenantDatasourceProvider.getDefaultSchema()) ?
                "" : AbstractTenantDatasourceProvider.getDefaultSchema() + "_";
        return prefix + tenant.getSchemaName();
    }
}
