package org.hibernate.annotations;

import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.PACKAGE;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * <p>
 * 功能说明:覆盖源码 支持继承
 *  具体源码参见 org.hibernate.annotations#FilterDef
 * </p>
 *
 * @author roman
 * @since 2022/2/23 5:22 PM
 */
@Target({TYPE, PACKAGE})
@Retention(RUNTIME)
@Repeatable(FilterDefs.class)
public @interface FilterDef {
    /**
     * The filter name.
     */
    String name();

    /**
     * The default filter condition.
     */
    String defaultCondition() default "";

    /**
     * The filter parameter definitions.
     */
    ParamDef[] parameters() default {};
}

