package com.elitescloud.boot.jpa.config.auditing;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.constant.CommonConstant;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.context.TenantOrgContext;
import com.elitescloud.boot.jpa.CloudtDataProperties;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;

import javax.annotation.Nonnull;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 自定义审计处理器.
 *
 * @author Kaiser（wang shao）
 * @date 2021-03-04
 */
@Slf4j
public class CustomAuditHandler extends AuditingHandler {

    private TenantClientProvider tenantClientProvider;
    private UserDetailProvider userProvider;
    private CloudtDataProperties dataProperties;
    private List<AuditCustomizer> customizers;

    public CustomAuditHandler(MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext) {
        super(mappingContext);
    }

    public CustomAuditHandler(PersistentEntities entities) {
        super(entities);
    }

    @Nonnull
    @Override
    public <T> T markCreated(@Nonnull T source) {

        return CustomAuditUtil.markCreated(source) ;
    }

    @Nonnull
    @Override
    public <T> T markModified(@Nonnull T source) {
        return CustomAuditUtil.markModified(source);
    }

//    protected String obtainCurrentUserName(GeneralUserDetails currentUser) {
//        if (currentUser == null) {
//            currentUser = this.currentUser();
//        }
//        if (currentUser == null) {
//            return null;
//        }
//
//        var auditorType = ObjectUtil.defaultIfNull(getDataProperties().getAuditorType(), CloudtDataProperties.AuditorType.FULL_NAME);
//        switch (auditorType) {
//            case FULL_NAME:
//                return currentUser.getUser().getPrettyName();
//            case USER_NAME:
//                return currentUser.getUsername();
//            case CUSTOM:
//                log.warn("暂不支持自定义");
//                return currentUser.getUser().getPrettyName();
//            default:
//                return null;
//        }
//    }
//
//    protected Long obtainTenantId() {
//        var currentTenant = getTenantClientProvider().getSessionTenant();
//        if (currentTenant != null) {
//            return currentTenant.getId();
//        }
//
//        return TenantConstant.DEFAULT_TENANT_ID;
//    }
//
//    protected Long obtainTenantOrgId() {
//        var useTenantOrg = TenantOrgContext.isUseTenantOrg();
//        if (!ObjectUtil.defaultIfNull(useTenantOrg, true)) {
//            // 不使用租户组织
//            return null;
//        }
//
//        return TenantOrgContext.getTenantOrg();
//    }
//
//    protected GeneralUserDetails currentUser() {
//        if (userProvider == null) {
//            userProvider = SpringContextHolder.getBean(UserDetailProvider.class);
//        }
//        return userProvider.currentUser();
//    }
//
//    protected TenantClientProvider getTenantClientProvider() {
//        if (tenantClientProvider == null) {
//            tenantClientProvider = SpringContextHolder.getBean(TenantClientProvider.class);
//        }
//        return tenantClientProvider;
//    }
//
//    public CloudtDataProperties getDataProperties() {
//        if (dataProperties == null) {
//            dataProperties = SpringContextHolder.getBean(CloudtDataProperties.class);
//        }
//        return dataProperties;
//    }
//
//    protected List<AuditCustomizer> getCustomizers() {
//        if (customizers == null) {
//            customizers = SpringContextHolder.getObjectProvider(AuditCustomizer.class).stream().collect(Collectors.toList());
//        }
//        return customizers;
//    }
}
