package com.elitescloud.boot.jpa.config.tenant;

import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.tenant.client.common.AbstractTenantDatasourceProvider;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import lombok.extern.log4j.Log4j2;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;

/**
 * 多租户id处理.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/25
 */
@Log4j2
public class HibernateTenantIdentifierResolver implements CurrentTenantIdentifierResolver {

    @Override
    public String resolveCurrentTenantIdentifier() {
        SysTenantDTO tenant = AbstractTenantDatasourceProvider.detectedTenant();
        return tenant == null ? TenantConstant.DEFAULT_TENANT_ID.toString() : tenant.getId().toString();
    }

    @Override
    public boolean validateExistingCurrentSessions() {
        return true;
    }
}
