package com.elitescloud.boot.jpa.support.id.provider.uidgenerator.config;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

/**
 * uid-generator属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/9
 */
public class UidProperties {

    /**
     * 时间序列位数，timeBits + workerBits + seqBits = 63
     * 默认68年
     */
    private int timeBits = 31;
    /**
     * workerId位数
     * 默认4096个worker
     */
    private int workerBits = 12;
    /**
     * 每秒的并发序列
     * 默认1048576个并发
     */
    private int seqBits = 20;

    /**
     * RingBuffer Size扩容参数
     * 默认838.8608万，原bufferSize=1048576，扩容后1048576 << 3 = 838.8608万
     */
    @Min(value = 1, message = "boostPower最小为1")
    private int boostPower = 3;

    /**
     * RingBuffer的扩容因子，取值百分比（0， 100）
     * 默认50，即如果bufferSize=1024，则1024*50/100=512时进行对RingBuffer填充补全
     */
    @Min(value = 1, message = "paddingFactor最小为1")
    @Max(value = 99, message = "paddingFactor最大为99")
    private int paddingFactor = 50;

    /**
     * 起始时间，格式yyyy-MM-dd
     */
    private String epochStr = "2022-12-01";

    /**
     * worker标识，手动指定是必须
     */
    private Long workerId = 1L;

    /**
     * 缓存key的前缀，genAuto=true时设置有效
     */
    private String cachePrefix = "cloudt_uid";

    public int getTimeBits() {
        return timeBits;
    }

    public void setTimeBits(int timeBits) {
        this.timeBits = timeBits;
    }

    public int getWorkerBits() {
        return workerBits;
    }

    public void setWorkerBits(int workerBits) {
        this.workerBits = workerBits;
    }

    public int getSeqBits() {
        return seqBits;
    }

    public void setSeqBits(int seqBits) {
        this.seqBits = seqBits;
    }

    public int getBoostPower() {
        return boostPower;
    }

    public void setBoostPower(int boostPower) {
        this.boostPower = boostPower;
    }

    public int getPaddingFactor() {
        return paddingFactor;
    }

    public void setPaddingFactor(int paddingFactor) {
        this.paddingFactor = paddingFactor;
    }

    public String getEpochStr() {
        return epochStr;
    }

    public void setEpochStr(String epochStr) {
        this.epochStr = epochStr;
    }

    public Long getWorkerId() {
        return workerId;
    }

    public void setWorkerId(Long workerId) {
        this.workerId = workerId;
    }

    public String getCachePrefix() {
        return cachePrefix;
    }

    public void setCachePrefix(String cachePrefix) {
        this.cachePrefix = cachePrefix;
    }
}
