/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.config;

import cn.hutool.core.util.ObjectUtil;
import com.blazebit.persistence.Criteria;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.spi.CriteriaBuilderConfiguration;
import com.elitescloud.boot.jpa.CloudtDataProperties;
import com.elitescloud.boot.jpa.CloudtJpaProperties;
import com.elitescloud.boot.jpa.support.dialect.MySQL5Dialect;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

public class HibernateConfig {
    private final CloudtJpaProperties jpaProperties;

    public HibernateConfig(CloudtJpaProperties jpaProperties) {
        this.jpaProperties = jpaProperties;
    }

    @Bean
    public HibernatePropertiesCustomizer hibernatePropertiesCustomizer() {
        return hibernateProperties -> {
            hibernateProperties.putIfAbsent("hibernate.use_sql_comments", false);
            hibernateProperties.putIfAbsent("hibernate.schema_update.unique_constraint_strategy", "RECREATE_QUIETLY");
            hibernateProperties.putIfAbsent("hibernate.jdbc.batch_size", 50);
            hibernateProperties.putIfAbsent("hibernate.order_inserts", "true");
            hibernateProperties.putIfAbsent("hibernate.order_updates", "true");
            hibernateProperties.putIfAbsent("hibernate.jdbc.batch_versioned_data", "true");
            hibernateProperties.putIfAbsent("hibernate.dialect", MySQL5Dialect.class.getName());
        };
    }

    @Bean
    public JPAQueryFactory jpaQueryFactory(EntityManager em, ObjectProvider<UserDetailProvider> userProvider, CloudtDataProperties dataProperties) {
        return new CloudtJPAQueryFactory(em, (UserDetailProvider)userProvider.getIfAvailable(), dataProperties);
    }

    @Bean
    @Scope(value="singleton")
    public CriteriaBuilderFactory criteriaBuilderFactory(EntityManagerFactory entityManagerFactory) {
        CriteriaBuilderConfiguration criteria = Criteria.getDefault();
        criteria.setProperty("com.blazebit.persistence.compatible_mode", this.jpaProperties.getBlaze().getCompatibleMode().toString());
        criteria.setProperty("com.blazebit.persistence.returning_clause_case_sensitive", this.jpaProperties.getBlaze().getReturningClauseCaseSensitive().toString());
        criteria.setProperty("com.blazebit.persistence.size_to_count_transformation", this.jpaProperties.getBlaze().getSizeToCountTransformation().toString());
        criteria.setProperty("com.blazebit.persistence.implicit_group_by_from_select", this.jpaProperties.getBlaze().getImplicitGroupByFromSelect().toString());
        criteria.setProperty("com.blazebit.persistence.implicit_group_by_from_having", this.jpaProperties.getBlaze().getImplicitGroupByFromHaving().toString());
        criteria.setProperty("com.blazebit.persistence.implicit_group_by_from_order_by", this.jpaProperties.getBlaze().getImplicitGroupByFromOrderBy().toString());
        criteria.setProperty("com.blazebit.persistence.expression_optimization", this.jpaProperties.getBlaze().getExpressionOptimization().toString());
        criteria.setProperty("com.blazebit.persistence.expression.cache_class", this.jpaProperties.getBlaze().getCacheClass());
        criteria.setProperty("com.blazebit.persistence.values.filter_nulls", this.jpaProperties.getBlaze().getFilterNulls().toString());
        criteria.setProperty("com.blazebit.persistence.parameter_literal_rendering", this.jpaProperties.getBlaze().getParameterLiteralRendering().toString());
        criteria.setProperty("com.blazebit.persistence.optimized_keyset_predicate_rendering", this.jpaProperties.getBlaze().getOptimizedKeysetPredicateRendering().toString());
        criteria.setProperty("com.blazebit.persistence.inline_id_query", this.jpaProperties.getBlaze().getInlineIdQuery());
        criteria.setProperty("com.blazebit.persistence.inline_count_query", this.jpaProperties.getBlaze().getInlineCountQuery());
        criteria.setProperty("com.blazebit.persistence.inline_ctes", this.jpaProperties.getBlaze().getInlineCtes());
        criteria.setProperty("com.blazebit.persistence.query_plan_cache_enabled", this.jpaProperties.getBlaze().getQueryPlanCacheEnabled().toString());
        criteria.setProperty("com.blazebit.persistence.criteria_negation_wrapper", this.jpaProperties.getBlaze().getCriteriaNegationWrapper().toString());
        criteria.setProperty("com.blazebit.persistence.criteria_value_as_parameter", this.jpaProperties.getBlaze().getCriteriaValueAsParameter().toString());
        return criteria.createCriteriaBuilderFactory(entityManagerFactory);
    }

    static class CloudtJPAQueryFactory
    extends JPAQueryFactory {
        private static final Logger log = LoggerFactory.getLogger(CloudtJPAQueryFactory.class);
        private final UserDetailProvider userProvider;
        private final CloudtDataProperties dataProperties;

        public CloudtJPAQueryFactory(EntityManager entityManager, UserDetailProvider userProvider, CloudtDataProperties dataProperties) {
            super(entityManager);
            this.userProvider = userProvider;
            this.dataProperties = dataProperties;
        }

        public JPAUpdateClause update(EntityPath<?> path) {
            JPAUpdateClause clause = super.update(path);
            this.auditForUpdate(path, clause);
            return clause;
        }

        private void auditForUpdate(EntityPath<?> path, JPAUpdateClause clause) {
            if (BaseModel.class.isAssignableFrom(path.getType())) {
                GeneralUserDetails user;
                LocalDateTime now = LocalDateTime.now();
                clause.set((Path)Expressions.dateTimePath(LocalDateTime.class, path, (String)"modifyTime"), (Object)now);
                GeneralUserDetails generalUserDetails = user = this.userProvider == null ? null : this.userProvider.currentUser();
                if (user != null) {
                    clause.set((Path)Expressions.numberPath(Long.class, path, (String)"modifyUserId"), (Object)user.getUserId());
                    clause.set((Path)Expressions.stringPath(path, (String)"updater"), (Object)this.obtainCurrentUserName(user));
                }
            }
        }

        private String obtainCurrentUserName(GeneralUserDetails currentUser) {
            if (currentUser == null) {
                return null;
            }
            CloudtDataProperties.AuditorType auditorType = (CloudtDataProperties.AuditorType)((Object)ObjectUtil.defaultIfNull((Object)((Object)this.dataProperties.getAuditorType()), (Object)((Object)CloudtDataProperties.AuditorType.FULL_NAME)));
            switch (auditorType) {
                case FULL_NAME: {
                    return currentUser.getUser().getPrettyName();
                }
                case USER_NAME: {
                    return currentUser.getUsername();
                }
                case CUSTOM: {
                    log.warn("\u6682\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49");
                    return currentUser.getUser().getPrettyName();
                }
            }
            return null;
        }
    }
}

