package com.elitescloud.boot.jpa.config.auditing;

import lombok.extern.slf4j.Slf4j;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;

import javax.annotation.Nonnull;

/**
 * 自定义审计处理器.
 *
 * @author Kaiser（wang shao）
 * @date 2021-03-04
 */
@Slf4j
public class CustomAuditHandler extends AuditingHandler {

    public CustomAuditHandler(MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext) {
        super(mappingContext);
    }

    public CustomAuditHandler(PersistentEntities entities) {
        super(entities);
    }

    @Nonnull
    @Override
    public <T> T markCreated(@Nonnull T source) {
        return CustomAuditUtil.markCreated(source);
    }

    @Nonnull
    @Override
    public <T> T markModified(@Nonnull T source) {
        return CustomAuditUtil.markModified(source);
    }
}
