/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.config.auditing;

import cn.hutool.core.util.ReflectUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.data.support.audit.CustomAuditUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.jpa.common.PartitionField;
import com.elitescloud.boot.util.BeanWrapperUtil;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;

public class CustomAuditHandler
extends AuditingHandler {
    private static final Logger logger = CloudtBootLoggerFactory.REPO_JPA.getLogger(CustomAuditHandler.class);

    public CustomAuditHandler(MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext) {
        super(mappingContext);
    }

    public CustomAuditHandler(PersistentEntities entities) {
        super(entities);
    }

    @Nonnull
    public <T> T markCreated(@Nonnull T source) {
        CustomAuditHandler.partitionFieldHandler(source);
        return (T)CustomAuditUtil.markCreated(source);
    }

    @Nonnull
    public <T> T markModified(@Nonnull T source) {
        return (T)CustomAuditUtil.markModified(source);
    }

    private static <T> void partitionFieldHandler(T source) {
        List fields = BeanWrapperUtil.getFieldsByAnnotation(source, PartitionField.class, (boolean)true);
        if (fields.isEmpty()) {
            return;
        }
        LocalDate currentDate = LocalDate.now();
        for (BeanWrapperUtil.CustomField field : fields) {
            PartitionField anno = (PartitionField)field.getAnnotation(PartitionField.class);
            if (anno == null) continue;
            PartitionField.PartitionType partitionType = anno.value();
            Object partitionValue = "";
            switch (partitionType) {
                case YEAR: {
                    partitionValue = "" + currentDate.getYear();
                    break;
                }
                case YEAR_MONTH: {
                    partitionValue = currentDate.format(DateTimeFormatter.ofPattern("yyyyMM"));
                    break;
                }
                case YEAR_MONTH_DAY: {
                    partitionValue = currentDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                }
            }
            try {
                ReflectUtil.invoke(source, (Method)field.getWriteMethod(), (Object[])new Object[]{partitionValue});
            }
            catch (Exception e) {
                throw new BusinessException("\u5206\u533a\u5b57\u6bb5\u5904\u7406\u5f02\u5e38\uff1a" + field.getName() + "," + (String)partitionValue, (Throwable)e);
            }
        }
    }
}

