/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.config.tenant;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.tenant.client.common.AbstractTenantDatasourceProvider;
import com.elitescloud.cloudt.context.util.database.SqlUtil;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.hibernate.engine.jdbc.connections.spi.AbstractDataSourceBasedMultiTenantConnectionProviderImpl;
import org.slf4j.Logger;
import org.springframework.orm.jpa.vendor.Database;

public class HibernateTenantDatasourceProvider
extends AbstractDataSourceBasedMultiTenantConnectionProviderImpl {
    private static final Logger logger = CloudtBootLoggerFactory.REPO_JPA.getLogger(HibernateTenantDatasourceProvider.class);
    private static final long serialVersionUID = -3009600657851822507L;

    public Connection getConnection(String tenantIdentifier) throws SQLException {
        Connection connection = super.getConnection(tenantIdentifier);
        String schema = this.getTenantSchema(tenantIdentifier);
        Database database = AbstractTenantDatasourceProvider.getDatabaseType();
        logger.debug("use schema '{}' for tenant '{}'", (Object)schema, (Object)tenantIdentifier);
        String command = SqlUtil.generateSwitchSchemaSql((Database)database, (String)schema);
        try (Statement statement = connection.createStatement();){
            statement.execute(command);
        }
        return connection;
    }

    protected DataSource selectAnyDataSource() {
        return AbstractTenantDatasourceProvider.getDefaultDataSource();
    }

    protected DataSource selectDataSource(String tenantIdentifier) {
        return AbstractTenantDatasourceProvider.getDefaultDataSource();
    }

    private String getTenantSchema(String tenantIdentifier) {
        if (TenantConstant.DEFAULT_TENANT_ID.toString().equals(tenantIdentifier)) {
            return AbstractTenantDatasourceProvider.getDefaultSchema();
        }
        SysTenantDTO tenant = AbstractTenantDatasourceProvider.detectedTenant();
        if (tenant == null) {
            return AbstractTenantDatasourceProvider.getDefaultSchema();
        }
        Object prefix = CharSequenceUtil.isBlank((CharSequence)AbstractTenantDatasourceProvider.getDefaultSchema()) ? "" : AbstractTenantDatasourceProvider.getDefaultSchema() + "_";
        return (String)prefix + tenant.getSchemaName();
    }
}

