/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.jpa.config.tenant.HibernateTenantDatasourceProvider;
import com.elitescloud.boot.jpa.config.tenant.HibernateTenantIdentifierResolver;
import com.elitescloud.boot.support.CloudtStarterTool;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import java.util.Map;
import org.hibernate.MultiTenancyStrategy;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

class CloudtJpaTenantEnvironmentListener
implements SmartApplicationListener,
Ordered {
    private static final String TENANT_CONFIG_PREFIX = "elitesland.tenant.client";

    CloudtJpaTenantEnvironmentListener() {
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType.isAssignableFrom(ApplicationContextInitializedEvent.class);
    }

    public void onApplicationEvent(@NonNull ApplicationEvent event) {
        if (event instanceof ApplicationContextInitializedEvent) {
            ConfigurableEnvironment env = ((ApplicationContextInitializedEvent)event).getApplicationContext().getEnvironment();
            if (!(env instanceof StandardEnvironment)) {
                return;
            }
            StandardEnvironment environment = (StandardEnvironment)((ApplicationContextInitializedEvent)event).getApplicationContext().getEnvironment();
            if (!CloudtStarterTool.enabledTenant((Environment)environment)) {
                return;
            }
            PropertySource propertySource = environment.getPropertySources().get("defaultProperties");
            if (propertySource == null) {
                throw new IllegalStateException("\u7f3a\u5c11\u9ed8\u8ba4PropertySource");
            }
            Map defaultProperties = (Map)propertySource.getSource();
            MultiTenancyStrategy tenancyStrategy = CloudtJpaTenantEnvironmentListener.getTenantStrategy((Environment)environment);
            if (tenancyStrategy == MultiTenancyStrategy.SCHEMA) {
                CloudtJpaTenantEnvironmentListener.propertiesForSchemaIsolate((ConfigurableEnvironment)environment, defaultProperties);
            } else if (tenancyStrategy != MultiTenancyStrategy.DATABASE && tenancyStrategy == MultiTenancyStrategy.DISCRIMINATOR) {
                CloudtJpaTenantEnvironmentListener.propertiesForFieldIsolate((ConfigurableEnvironment)environment, defaultProperties);
            }
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private static void propertiesForFieldIsolate(ConfigurableEnvironment environment, Map<String, Object> defaultProperties) {
        defaultProperties.put("spring.jpa.properties.hibernate.multiTenancy", MultiTenancyStrategy.DISCRIMINATOR.name());
        defaultProperties.put("spring.jpa.properties.hibernate.tenant_identifier_resolver", HibernateTenantIdentifierResolver.class.getName());
    }

    private static void propertiesForSchemaIsolate(ConfigurableEnvironment environment, Map<String, Object> defaultProperties) {
        defaultProperties.put("spring.jpa.properties.hibernate.multiTenancy", MultiTenancyStrategy.SCHEMA.name());
        defaultProperties.put("spring.jpa.properties.hibernate.tenant_identifier_resolver", HibernateTenantIdentifierResolver.class.getName());
        defaultProperties.put("spring.jpa.properties.hibernate.multi_tenant_connection_provider", HibernateTenantDatasourceProvider.class.getName());
        String schemaDefault = environment.getProperty("elitesland.flyway.schema-default");
        if (StringUtils.hasText((String)schemaDefault)) {
            schemaDefault = environment.getProperty("elitesland.tenant.client.default-schema");
        }
        if (StringUtils.hasText((String)schemaDefault)) {
            defaultProperties.put("elitesland.flyway.schema-default", schemaDefault);
            defaultProperties.put("elitesland.tenant.client.default-schema", schemaDefault);
        }
        String enabledFlyway = environment.getProperty("elitesland.flyway.enabled", "true");
        defaultProperties.put("elitesland.flyway.enabled", enabledFlyway);
        defaultProperties.put("spring.jpa.hibernate.ddl-auto", "none");
        defaultProperties.put("spring.jpa.properties.hibernate.hbm2ddl.auto", "none");
    }

    private static MultiTenancyStrategy getTenantStrategy(Environment environment) {
        String isoLateStrategy = environment.getProperty("elitesland.tenant.client.isolate-strategy");
        if (!StringUtils.hasText((String)isoLateStrategy) || CharSequenceUtil.equals((CharSequence)isoLateStrategy, (CharSequence)TenantIsolateStrategy.NONE.name())) {
            return MultiTenancyStrategy.NONE;
        }
        if (CharSequenceUtil.equals((CharSequence)isoLateStrategy, (CharSequence)TenantIsolateStrategy.SCHEMA.name())) {
            return MultiTenancyStrategy.SCHEMA;
        }
        if (CharSequenceUtil.equals((CharSequence)isoLateStrategy, (CharSequence)TenantIsolateStrategy.FIELD.name())) {
            return MultiTenancyStrategy.DISCRIMINATOR;
        }
        if (CharSequenceUtil.equals((CharSequence)isoLateStrategy, (CharSequence)TenantIsolateStrategy.DATABASE.name())) {
            return MultiTenancyStrategy.DATABASE;
        }
        return MultiTenancyStrategy.NONE;
    }
}

