/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tool;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.interfaces.RSAPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtEncoder;
import org.springframework.util.Assert;

public class JwtUtil {
    private static final Logger logger = LoggerFactory.getLogger(JwtUtil.class);

    public static JwtDecoder buildJwtDecoder(@NonNull RSAKey rsaKey) {
        Assert.notNull((Object)rsaKey, (String)"rsaKey\u4e3a\u7a7a");
        try {
            return NimbusJwtDecoder.withPublicKey((RSAPublicKey)rsaKey.toRSAPublicKey()).build();
        }
        catch (JOSEException e) {
            logger.error("jwtDecoder\u6784\u5efa\u5931\u8d25\uff1a", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static JwtEncoder buildJwtEncoder(@NonNull RSAKey rsaKey) {
        Assert.notNull((Object)rsaKey, (String)"rsaKey\u4e3a\u7a7a");
        JWKSource<SecurityContext> jwkSource = JwtUtil.generateJwkSource(rsaKey);
        return new NimbusJwtEncoder(jwkSource);
    }

    public static RSAKey loadRSAKey(@NonNull KeyStore keyStore, String alias, @NonNull String secret) {
        Assert.notNull((Object)keyStore, (String)"keyStore\u4e3a\u7a7a");
        Assert.hasText((String)alias, (String)"alias\u4e3a\u7a7a");
        Assert.hasText((String)secret, (String)"secret\u4e3a\u7a7a");
        try {
            return RSAKey.load((KeyStore)keyStore, (String)alias, (char[])secret.toCharArray());
        }
        catch (Exception e) {
            logger.error("rsaKey\u52a0\u8f7d\u5931\u8d25\uff1a", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static KeyStore loadKeystore(@NonNull InputStream keystoreStream, String type, String password, String alias, String secret) {
        Assert.hasText((String)password, (String)"password\u4e3a\u7a7a");
        Assert.hasText((String)alias, (String)"alias\u4e3a\u7a7a");
        Assert.hasText((String)secret, (String)"secret\u4e3a\u7a7a");
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(type);
            keyStore.load(keystoreStream, password.toCharArray());
        }
        catch (Exception e) {
            logger.error("keystore\u52a0\u8f7d\u5931\u8d25\uff1a", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return keyStore;
    }

    public static KeyStore loadKeystore(@NonNull Resource keystoreResource, String type, @NonNull String password, String alias, String secret) {
        Assert.isTrue((boolean)keystoreResource.exists(), (String)"keystore\u4e0d\u5b58\u5728");
        InputStream keystoreStream = null;
        try {
            keystoreStream = keystoreResource.getInputStream();
        }
        catch (IOException e) {
            logger.error("\u52a0\u8f7dkeystore\u5931\u8d25\uff1a", (Throwable)e);
            throw new IllegalArgumentException("\u52a0\u8f7dkeystore\u5931\u8d25", e);
        }
        return JwtUtil.loadKeystore(keystoreStream, type, password, alias, secret);
    }

    public static JWKSource<SecurityContext> generateJwkSource(@NonNull RSAKey rsaKey) {
        JWKSet jwkSet = new JWKSet((JWK)rsaKey);
        return (jwkSelector, securityContext) -> jwkSelector.select(jwkSet);
    }
}

