/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tool;

import com.elitescloud.boot.tool.JwtUtil;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.KeyStore;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TokenParser {
    private static final Logger logger = LoggerFactory.getLogger(TokenParser.class);
    private final JwtDecoder jwtDecoder;

    private TokenParser(RSAKey rsaKey) {
        this.jwtDecoder = JwtUtil.buildJwtDecoder(rsaKey);
    }

    public static TokenParser instance() {
        RSAKey rsa = null;
        try {
            ClassPathResource classPathResource = new ClassPathResource("yst-config.jks");
            KeyStore keystore = JwtUtil.loadKeystore(classPathResource.getInputStream(), "jks", "elitesland516", "yst-config", "elitesland516");
            rsa = JwtUtil.loadRSAKey(keystore, "yst-config", "elitesland516");
        }
        catch (Exception e) {
            logger.error("\u79d8\u94a5\u5e93\u8bfb\u53d6\u5f02\u5e38\uff1a", (Throwable)e);
            throw new IllegalArgumentException("\u79d8\u94a5\u5e93\u8bfb\u53d6\u5f02\u5e38", e);
        }
        return new TokenParser(rsa);
    }

    public static TokenParser instance(@NotNull RSAKey rsaKey) {
        Assert.notNull((Object)rsaKey, (String)"RSAKey\u4e3a\u7a7a");
        return new TokenParser(rsaKey);
    }

    public CloudtJwt parse(@NotBlank String token) {
        Assert.hasText((String)token, (String)"token\u4e3a\u7a7a");
        Jwt jwt = this.jwtDecoder.decode(token);
        return new CloudtJwt(jwt);
    }

    public static class CloudtJwt {
        private final Jwt jwt;

        private CloudtJwt(Jwt jwt) {
            this.jwt = jwt;
        }

        public Jwt getOriginalJwt() {
            return this.jwt;
        }

        public String getUsername() {
            return this.jwt.getSubject();
        }

        public Long getUserId() {
            return this.getClaimAsLong("yst_ui");
        }

        public Long getTenantId() {
            return this.getClaimAsLong("yst_ti");
        }

        private Long getClaimAsLong(String claim) {
            String claimValue = this.jwt.getClaimAsString(claim);
            if (!StringUtils.hasText((String)claimValue)) {
                return null;
            }
            return Long.parseLong(claimValue);
        }
    }
}

