/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log;

import com.elitescloud.boot.log.config.LogRepositoryProperties;
import java.time.Duration;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="elitesland.log")
public class LogProperties {
    public static final String CONFIG_PREFIX = "elitesland.log";
    private Boolean enabled = true;
    private final ThreadPool threadPool = new ThreadPool();
    @NestedConfigurationProperty
    private LogRepositoryProperties repository = new LogRepositoryProperties();
    @Valid
    private final AccessLog accessLog = new AccessLog();
    private final LoginLog loginLog = new LoginLog();

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setRepository(LogRepositoryProperties repository) {
        this.repository = repository;
    }

    public LogRepositoryProperties getRepository() {
        return this.repository;
    }

    public AccessLog getAccessLog() {
        return this.accessLog;
    }

    public LoginLog getLoginLog() {
        return this.loginLog;
    }

    public static class ThreadPool {
        private String threadNamePrefix = "cloudt-log-";
        private Integer coreSize = 8;
        private Integer maxSize = 64;

        public String getThreadNamePrefix() {
            return this.threadNamePrefix;
        }

        public void setThreadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
        }

        public Integer getCoreSize() {
            return this.coreSize;
        }

        public void setCoreSize(Integer coreSize) {
            this.coreSize = coreSize;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }
    }

    public static class AccessLog {
        private Boolean enabled = false;
        @Valid
        private List<Matcher> excludedRequest;
        @Valid
        private List<Matcher> recordResponseBody;
        @Valid
        private List<Matcher> recordRequestBody;
        private Integer max = 512;
        private Duration persistenceRate = Duration.ofSeconds(20L);
        private Duration timeToLive = Duration.ofDays(30L);

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public List<Matcher> getExcludedRequest() {
            return this.excludedRequest;
        }

        public void setExcludedRequest(List<Matcher> excludedRequest) {
            this.excludedRequest = excludedRequest;
        }

        public List<Matcher> getRecordResponseBody() {
            return this.recordResponseBody;
        }

        public void setRecordResponseBody(List<Matcher> recordResponseBody) {
            this.recordResponseBody = recordResponseBody;
        }

        public List<Matcher> getRecordRequestBody() {
            return this.recordRequestBody;
        }

        public void setRecordRequestBody(List<Matcher> recordRequestBody) {
            this.recordRequestBody = recordRequestBody;
        }

        public Integer getMax() {
            return this.max;
        }

        public void setMax(Integer max) {
            this.max = max;
        }

        public Duration getPersistenceRate() {
            return this.persistenceRate;
        }

        public void setPersistenceRate(Duration persistenceRate) {
            this.persistenceRate = persistenceRate;
        }

        public Duration getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
        }
    }

    public static class LoginLog {
        private Boolean enabled = true;
        private Boolean userDetail = false;
        private Duration timeToLive = Duration.ofDays(180L);

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Boolean getUserDetail() {
            return this.userDetail;
        }

        public void setUserDetail(Boolean userDetail) {
            this.userDetail = userDetail;
        }

        public Duration getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
        }
    }

    @Validated
    public static class Matcher {
        @NotBlank(message="uri\u4e0d\u80fd\u4e3a\u7a7a")
        @Pattern(regexp="/[^?#]*", message="uri\u5fc5\u987b\u4ee5/\u5f00\u59cb")
        private @NotBlank(message="uri\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="/[^?#]*", message="uri\u5fc5\u987b\u4ee5/\u5f00\u59cb") String uri;

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }
    }
}

