/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.interceptor;

import cn.hutool.extra.servlet.ServletUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.log.model.bo.OperationLogVO;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.wrapper.CloudtRequestWrapper;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.nimbusds.jose.shaded.json.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class CustomResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LogManager.getLogger(CustomResponseBodyAdvice.class);
    @Autowired
    private RedisTemplate redisTemplate;
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    private final ThreadLocal<OperationLogVO> paramThreadLocal = new ThreadLocal();

    @ModelAttribute
    public void globalAttributes(HttpServletRequest request) {
        String operationConfigKey = "OPERATION-CONFIG-KEY";
        String requURI = request.getRequestURI();
        OperationLogVO operationLogVO = new OperationLogVO();
        operationLogVO.setOperationUrl(requURI);
        try {
            Map formMap;
            CloudtRequestWrapper wrapper;
            String body;
            boolean isStandkey = this.redisTemplate.opsForHash().hasKey((Object)operationConfigKey, (Object)requURI);
            if (isStandkey) {
                String ocObject = (String)this.redisTemplate.opsForHash().get((Object)operationConfigKey, (Object)requURI);
                Map ocMap = (Map)JSONUtil.json2Obj((String)ocObject, HashMap.class);
                if (ocMap.containsKey("sysModel")) {
                    operationLogVO.setSysModel(ocMap.get("sysModel").toString());
                }
                if (ocMap.containsKey("triggerTerminal")) {
                    operationLogVO.setTriggerTerminal(ocMap.get("triggerTerminal").toString());
                }
                if (ocMap.containsKey("operationType")) {
                    operationLogVO.setOperationType(ocMap.get("operationType").toString());
                }
            }
            operationLogVO.setOperationIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
            GeneralUserDetails generalUserDetails = SecurityContextUtil.currentUser();
            if (generalUserDetails != null) {
                operationLogVO.setOperationUser(generalUserDetails.getUsername());
            }
            Object requestParam = "";
            if (request instanceof CloudtRequestWrapper && StringUtils.isNotBlank((CharSequence)(body = (wrapper = (CloudtRequestWrapper)request).getBodyString()))) {
                String finalBody = this.removeControlCharacters(body);
                requestParam = "request body param :" + finalBody;
            }
            if ((formMap = request.getParameterMap()).size() > 0) {
                requestParam = StringUtils.isNotBlank((CharSequence)requestParam) ? (String)requestParam + "; request form param: " + JSONObject.toJSONString((Map)request.getParameterMap()) : "request form param: " + JSONObject.toJSONString((Map)request.getParameterMap());
            }
            operationLogVO.setRequestParam((String)requestParam);
            operationLogVO.setOperationTime(LocalDateTime.now());
            String logId = UUID.randomUUID().toString();
            operationLogVO.setLogId(logId);
            operationLogVO.setRequestMethod(request.getMethod());
            request.setAttribute("logId", (Object)logId);
            this.paramThreadLocal.set(operationLogVO);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6" + requURI + "\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
    }

    public String removeControlCharacters(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("\\p{C}", "");
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<String> handleException(Exception ex) {
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        String message = ex.getMessage();
        if (this.paramThreadLocal.get() != null) {
            OperationLogVO operationLogVO = this.paramThreadLocal.get();
            operationLogVO.setOperationStatus("\u5931\u8d25");
            operationLogVO.setExceptionDesc(this.getExceptionAllInfo(ex));
            log.error("\u6267\u884c\u63a5\u53e3" + operationLogVO.getOperationUrl() + "\u5931\u8d25", (Throwable)ex);
            log.error("\u6267\u884c\u63a5\u53e3" + operationLogVO.getOperationUrl() + "\u5931\u8d25,\u65e5\u5fd7\u4fe1\u606f:" + operationLogVO.toString());
        }
        ResponseEntity response = new ResponseEntity((Object)message, status);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExceptionAllInfo(Exception ex) {
        ByteArrayOutputStream out = null;
        String ret = "";
        try (PrintStream pout = null;){
            out = new ByteArrayOutputStream();
            pout = new PrintStream(out);
            ex.printStackTrace(pout);
            ret = new String(out.toByteArray());
            out.close();
        }
        return ret;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (this.paramThreadLocal.get() != null) {
            OperationLogVO operationLogVO = this.paramThreadLocal.get();
            operationLogVO.setOperationStatus("\u6210\u529f");
            if (body != null) {
                operationLogVO.setResponseParam(body.toString());
            }
            log.info("\u6267\u884cAPI \u63a5\u53e3" + operationLogVO.getOperationUrl() + "\u6210\u529f,\u65e5\u5fd7\u4fe1\u606f:" + operationLogVO.toString());
        }
        return body;
    }
}

