package com.elitescloud.boot.log.common;

import com.elitescloud.boot.log.interceptor.BusinessOperationAspect;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-11 19:16
 */

@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface BusinessObjectOperation {

    //业务类型
//    String businessType();

    //操作类型枚举
    OperationTypeEnum operationType();

    //操作描述
    String operationDescription();

    //业务参数，用于业务查询
    String businessParam() default "-";

    //操作范围
    OperationScopeEnum operationScopeEnum() default OperationScopeEnum.PRIVATE_DOMAIN;
    //操作状态
    OperationStateEnum operationStateEnum() default OperationStateEnum.RELEASED;

    //是否记录日志
    boolean logEnabled() default false;

    //是否记录入参
    boolean argsJsonEnabled() default false;
    //是否记录出参
    boolean resultJsonEnabled() default false;

    //业务操作的业务对象关联，如果不填写默认关联类上@BusinessObject内容
    String businessObjectType() default BusinessOperationAspect.BUSINESS_OBJECT_NAME_DEFAULT;

    //业务入参对象的取值名称-当前版本不支持
    BusinessParmObjectTypeEnum businessParamObjectType() default BusinessParmObjectTypeEnum.ALL;
    //暂无用-业务参数取值key
    String businessParamValueKey() default "";



}
