package com.elitescloud.boot.log.common;

import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :  操作类型
 * @date : 2023-11-27 19:54
 */
public enum OperationTypeEnum {

    ADD("创建"),
    SAVE("保存"),
    SELECT_PAGE("分页查询"),
    SELECT("查询"),
    UPDATE("编辑"),
    DELETE("删除"),
    DELETE_LOGICALLY("逻辑删除"),

    EXPORT("导出"),
    IMPORT("导入"),
    UPLOAD ("上传"),
    DOWNLOAD("下载"),


    APPROVE_OK("审批通过"),
    APPROVE_REJECT("审批驳回"),
    APPROVE_REVOCATION("审批撤销"),
    APPROVE_DELEGATE("审批委派"),
    APPROVE_TRANSFER("审批转派"),
    ELSE("其他"),

    ;

    /**
     * 描述
     */
    private final String description;

    OperationTypeEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, TenantIsolateStrategy> VALUE_MAP = Arrays.stream(TenantIsolateStrategy.values()).collect(Collectors.toMap(TenantIsolateStrategy::name, t -> t, (t1, t2) -> t1));

    public static TenantIsolateStrategy parse(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.get(value);
    }
}
