package com.elitescloud.boot.log.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 请求类日志基础类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/18
 */
@Getter
@Setter
@Accessors(chain = true)
@MappedSuperclass
public abstract class BaseRequestLogEntity implements Serializable {
    private static final long serialVersionUID = -5007565668862753327L;

    @Id
//    @GenericGenerator(name = "el-id", strategy = IdGeneratorStrategy.DEFAULT)
    @GeneratedValue(strategy = GenerationType.AUTO, generator = "el-id")
    @Comment("主键ID")
    @Column
    private Long id;

    @Comment("请求时间")
    @Column()
    private LocalDateTime requestTime;

    @Comment("响应时间")
    @Column()
    private LocalDateTime responseTime;

    @Comment("访问耗时，毫秒")
    @Column
    private Long cost;

    @Comment("请求平台编码")
    @Column()
    private String platformCode;

    @Comment("请求OAuth2客户端ID")
    @Column()
    private String clientId;

    @Comment("请求用户Id")
    @Column()
    private Long userId;

    @Comment("请求用户名")
    @Column()
    private String username;

    @Comment("请求浏览器类型")
    @Column
    private String browser;

    @Comment("请求浏览器user-agent")
    @Column
    private String userAgent;

    @Comment("请求方式，（GET、POST、DELETE、PUT、PATCH）")
    @Column
    private String method;

    @Comment("请求内容类型")
    @Column
    private String reqContentType;

    @Comment("请求路径")
    @Column()
    private String uri;

    @Comment("请求接口名称，默认swagger注解获取")
    private String operation;

    @Comment("请求端IP")
    @Column
    private String reqIp;

    @Comment("请求端外网IP")
    @Column
    private String reqOuterIp;

    @Comment("请求归属地")
    @Column
    private String address;

    @Comment("请求路径查询参数")
    @Column(length = 3000)
    private String queryParams;

    @Comment("请求体body，JSON格式数据，脱敏的数据")
    @Column()
    @Lob
    private String requestBodyTxt;

    @Comment("服务端实例")
    @Column
    private String serverInstance;

    @Comment("服务端实例IP")
    @Column
    private String serverInstanceIp;

    @Comment("服务端应用编码，如cloudt-system")
    @Column()
    private String appCode;

    @Comment("状态码")
    @Column()
    private Integer resultCode;

    @Comment("是否请求成功")
    @Column()
    private Boolean success;

    @Comment("响应结果信息")
    @Column()
    private String msg;

    @Comment("异常详细信息")
    @Column()
    @Lob
    private String exception;
}
