package com.elitescloud.boot.log.provider.trace;

import com.elitescloud.cloudt.core.logInfo.tracking.EventTrackingInterface;
import com.elitescloud.cloudt.core.logInfo.tracking.EventTrackingLogLevelEnum;
import lombok.extern.slf4j.Slf4j;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.spi.StandardLevel;
import org.apache.skywalking.apm.toolkit.trace.ActiveSpan;

/**
 * log4j2的输入层实现
 *
 * @author niu.chen
 * @date 2021-06-12
 */
@Slf4j
public class EventTrackingLog4j2Impl implements EventTrackingInterface {

    @Override
    public void addEventTracking(EventTrackingLogLevelEnum level, String msg) {
        addEventTracking(level,msg,"");
    }

    @Override
    public void addEventTracking(EventTrackingLogLevelEnum level, String format, Object... arguments) {
        String formatMessage=null;
        if(arguments==null){
            formatMessage=format;
        }else{
            formatMessage= new ParameterizedMessage(format,arguments).getFormattedMessage();
        }
        if (level.intLevel() == StandardLevel.INFO.intLevel()) {
            log.info(formatMessage);
            ActiveSpan.info(formatMessage);
        } else if (level.intLevel() == StandardLevel.DEBUG.intLevel()) {
            log.debug(formatMessage);
            ActiveSpan.debug(formatMessage);
        } else if (level.intLevel() == StandardLevel.ERROR.intLevel()) {
            log.error(formatMessage);
            ActiveSpan.error(formatMessage);
        } else if (level.intLevel() == StandardLevel.WARN.intLevel()) {
            log.warn(formatMessage);
            ActiveSpan.debug(formatMessage);
        }
    }

    @Override
    public void info(String format, Object... arguments) {
        this.addEventTracking(EventTrackingLogLevelEnum.INFO, format, arguments);
    }

    @Override
    public void error(String format, Object... arguments) {
        this.addEventTracking(EventTrackingLogLevelEnum.ERROR, format, arguments);
    }

    @Override
    public void debug(String format, Object... arguments) {
        this.addEventTracking(EventTrackingLogLevelEnum.DEBUG, format, arguments);
    }

    @Override
    public void warn(String format, Object... arguments) {
        this.addEventTracking(EventTrackingLogLevelEnum.WARN, format, arguments);
    }
}
