/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.interceptor;

import com.elitescloud.boot.log.common.BusinessObject;
import com.elitescloud.boot.log.common.BusinessObjectOperation;
import com.elitescloud.boot.log.model.bo.OperationLogDTO;
import com.elitescloud.boot.log.service.OperationLogMqMessageService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.time.Instant;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.web.bind.annotation.RestController;

@Aspect
public class BusinessOperationAspect {
    private static final Logger log = LoggerFactory.getLogger(BusinessOperationAspect.class);
    public static final String AUTO = "auto";
    private final OperationLogMqMessageService operationLogService;
    private final ObjectMapper objectMapper = new ObjectMapper();
    public static final String BUSINESS_OBJECT_NAME_DEFAULT = "@BusinessObject";

    public BusinessOperationAspect(OperationLogMqMessageService operationLogService) {
        this.operationLogService = operationLogService;
    }

    @Around(value="@annotation(businessObjectOperation)")
    public Object logBusinessOperation(ProceedingJoinPoint joinPoint, BusinessObjectOperation businessObjectOperation) throws Throwable {
        if (!joinPoint.getTarget().getClass().isAnnotationPresent(RestController.class)) {
            log.error("\u6ce8\u89e3\u4f4d\u7f6e\u5f02\u5e38\uff1a{} BusinessOperationAnnotation \u89c4\u8303\u5e94\u7528\u5728  @RestController classes\u7684\u65b9\u6cd5\u4e2d", (Object)joinPoint.getTarget().getClass().getName());
        }
        if (BUSINESS_OBJECT_NAME_DEFAULT.equals(businessObjectOperation.businessObjectType()) && !joinPoint.getTarget().getClass().isAnnotationPresent(BusinessObject.class)) {
            log.error("\u6ce8\u89e3\u5f02\u5e38: \u8df3\u8fc7\uff0c\u7ee7\u7eed\u6267\u884c\u4e1a\u52a1\u4ee3\u7801\uff1a{} BusinessOperationAnnotation \u89c4\u8303\u5e94\u7528\u5728  @BusinessObjectAnnotation classes\u7684\u65b9\u6cd5\u4e2d", (Object)joinPoint.getTarget().getClass().getName());
            return joinPoint.proceed();
        }
        BusinessObject businessObject = joinPoint.getTarget().getClass().getAnnotation(BusinessObject.class);
        if (businessObjectOperation.logEnabled()) {
            Instant start = Instant.now();
            String argsJson = null;
            if (businessObjectOperation.argsJsonEnabled()) {
                argsJson = this.convertToJson(joinPoint.getArgs());
            }
            try {
                Object result = joinPoint.proceed();
                long timeElapsed = Duration.between(start, Instant.now()).toMillis();
                this.logOperation(result, argsJson, timeElapsed, businessObject, businessObjectOperation);
                return result;
            }
            catch (Exception e) {
                long timeElapsed = Duration.between(start, Instant.now()).toMillis();
                this.logOperationError(e, argsJson, timeElapsed, businessObject, businessObjectOperation);
                throw e;
            }
        }
        return joinPoint.proceed();
    }

    @Around(value="@within(businessObjectAnnotation)")
    public Object checkBusinessObjectAnnotation(ProceedingJoinPoint joinPoint, BusinessObject businessObjectAnnotation) throws Throwable {
        if (!joinPoint.getTarget().getClass().isAnnotationPresent(RestController.class)) {
            log.error("\u6ce8\u89e3\u4f4d\u7f6e\u5f02\u5e38\uff1a{} BusinessObjectAnnotation \u89c4\u8303\u5e94\u7528\u5728 @RestController classes", (Object)joinPoint.getTarget().getClass().getName());
        }
        return joinPoint.proceed();
    }

    private static String getBusinessType(BusinessObjectOperation businessObjectOperation, BusinessObject businessObject) {
        String businessType = BUSINESS_OBJECT_NAME_DEFAULT.equals(businessObjectOperation.businessObjectType()) ? businessObject.businessType() : businessObjectOperation.businessObjectType();
        return businessType;
    }

    private void logOperationError(Exception proceedErr, String argsJson, long timeElapsed, BusinessObject businessObject, BusinessObjectOperation businessObjectOperation) {
        try {
            String businessType = BusinessOperationAspect.getBusinessType(businessObjectOperation, businessObject);
            OperationLogDTO operationLogDTO = this.operationLogService.quickNewOperationLogDTO(businessType, businessObjectOperation.businessParam(), businessObjectOperation.operationType(), businessObjectOperation.operationDescription());
            operationLogDTO.setDelayed(timeElapsed);
            operationLogDTO.setOperationAfterData(argsJson);
            operationLogDTO.setOperationBeforeData(proceedErr.toString());
            operationLogDTO.setSource(AUTO);
            operationLogDTO.setSuccess(false);
            operationLogDTO.setExceptionDesc("\u63a5\u53e3\u6267\u884c\u5f02\u5e38\uff1a" + proceedErr.getMessage());
            ApiResult<String> apiResult = this.operationLogService.sendAsyncOperationLogMqMessage(operationLogDTO);
            if (!apiResult.isSuccess()) {
                log.error("\u64cd\u4f5c\u65e5\u5fd7\uff1a\u6d88\u606f\u53d1\u9001\u5931\u8d25 - {}", (Object)apiResult.getErrorMsg());
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u65e5\u5fd7\uff1a\u8bb0\u5f55\u5931\u8d25 - {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void logOperation(Object resultData, String argsJson, long timeElapsed, BusinessObject businessObject, BusinessObjectOperation businessObjectOperation) {
        try {
            ApiResult<String> apiResult;
            String resultJson = null;
            if (businessObjectOperation.resultJsonEnabled()) {
                resultJson = this.convertToJson(resultData);
            }
            String businessType = BusinessOperationAspect.getBusinessType(businessObjectOperation, businessObject);
            OperationLogDTO operationLogDTO = this.operationLogService.quickNewOperationLogDTO(businessType, businessObjectOperation.businessParam(), businessObjectOperation.operationType(), businessObjectOperation.operationDescription());
            operationLogDTO.setDelayed(timeElapsed);
            operationLogDTO.setOperationAfterData(argsJson);
            operationLogDTO.setOperationBeforeData(resultJson);
            operationLogDTO.setSource(AUTO);
            if (resultData instanceof ApiResult) {
                ApiResult result = (ApiResult)resultData;
                operationLogDTO.setSuccess(result.isSuccess());
                StringBuffer messageBu = new StringBuffer();
                if (result.isSuccess()) {
                    messageBu.append(result.getCode()).append(";").append(result.getMsg());
                } else {
                    messageBu.append(result.getCode()).append(";").append(result.getErrorMsg()).append(";").append(result.getErrorNo());
                }
                operationLogDTO.setExceptionDesc(messageBu.toString());
            }
            if (!(apiResult = this.operationLogService.sendAsyncOperationLogMqMessage(operationLogDTO)).isSuccess()) {
                log.error("\u64cd\u4f5c\u65e5\u5fd7\uff1a\u6d88\u606f\u53d1\u9001\u5931\u8d25 - {}", (Object)apiResult.getErrorMsg());
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u65e5\u5fd7\uff1a\u8bb0\u5f55\u5931\u8d25 - {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private String convertToJson(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u65e5\u5fd7\uff1aJSON\u8f6c\u6362\u5f02\u5e38 - " + e.getMessage(), (Throwable)e);
            return "\u8f6c\u6362\u5f02\u5e38: " + e.getMessage();
        }
    }

    private BusinessObjectOperation obtainAnnotation(ProceedingJoinPoint point) {
        if (point instanceof MethodInvocationProceedingJoinPoint) {
            BusinessObjectOperation annotation = ((MethodSignature)point.getSignature()).getMethod().getAnnotation(BusinessObjectOperation.class);
            return annotation;
        }
        return null;
    }
}

