package com.elitescloud.boot.log;

import com.elitescloud.boot.log.interceptor.BusinessOperationAspect;
import com.elitescloud.boot.log.operationlog.DynamicMessageService;
import com.elitescloud.boot.log.operationlog.OperationLogMqMessageDefaultServiceImpl;
import com.elitescloud.boot.log.operationlog.OperationLogMqMessageService;
import com.elitescloud.boot.log.operationlog.OperationLogMqMessageServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;

/**
 * @author : chen.niu
 * @description : .operation-log.enabled=true 或者未设置时被加载
 * @date : 2023-12-06 10:12
 */


//@Import(OperationLogConfig.class)
//@Order(98)
@Slf4j
public class CloudOperationLogAutoConfiguration {
    public CloudOperationLogAutoConfiguration () {
        log.info("启用操作日志");
    }
    @Bean
    public DynamicMessageService dynamicMessageService(StreamBridge streamBridge) {
        return new DynamicMessageService(streamBridge);
    }
    @Bean
    @ConditionalOnMissingBean
    public OperationLogMqMessageService operationLogMqMessageService(Environment environment) {
        return new OperationLogMqMessageDefaultServiceImpl(environment);
    }
    @Bean
    @ConditionalOnProperty(prefix = LogProperties.CONFIG_PREFIX + ".operation-log", name = "enabled", havingValue = "true")
    public OperationLogMqMessageService operationLogMqMessageService(Environment environment,
            DynamicMessageService dynamicMessageService,TaskExecutor taskExecutor) {
        return new OperationLogMqMessageServiceImpl(dynamicMessageService, environment, taskExecutor);
    }



    @ConditionalOnProperty(prefix = LogProperties.CONFIG_PREFIX + ".operation-log-aspect", name = "enabled", havingValue = "true")
    @Bean
    BusinessOperationAspect businessOperationLogAspect(OperationLogMqMessageService operationLogService) {
        return new BusinessOperationAspect(operationLogService);
    }

}
