package com.elitescloud.boot.log;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.log.interceptor.TraceIdInterceptor;
import com.elitescloud.boot.log.provider.trace.EventTrackingLog4j2Impl;
import com.elitescloud.boot.threadpool.common.ContextTransfer;
import com.elitescloud.cloudt.core.logInfo.tracking.EventTrackingInterface;
import org.slf4j.MDC;
import org.springframework.context.annotation.Bean;

import java.util.Map;

/**
 * 日志跟踪自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/22/2023
 */
class CloudtTraceAutoConfiguration {

    @Bean
    public EventTrackingInterface eventTrackingLog4j2() {
        return new EventTrackingLog4j2Impl();
    }

    @Bean
    public TraceIdInterceptor traceIdInterceptor() {
        return new TraceIdInterceptor();
    }

    @Bean
    public ContextTransfer<Map<String, String>> mdcContextTransfer() {
        return new ContextTransfer<>() {
            @Override
            public Map<String, String> getContext() {
                return MDC.getCopyOfContextMap();
            }

            @Override
            public void setContext(Map<String, String> context) {
                if (CollUtil.isEmpty(context)) {
                    return;
                }
                MDC.setContextMap(context);
            }

            @Override
            public void clearContext() {
                MDC.clear();
            }
        };
    }
}
