package com.elitescloud.boot.log.common;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author : chen.niu
 * @description : 业务对象注解 必须应用在
 * @date : 2023-12-11 19:16
 */

@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface BusinessObjectAnnotation {
    //是否启用
    boolean enabled() default true;
    //业务类型,约定操作类型约定格式： 英文名称:中文名称
    //可创建常量类维护 英文名称不空，中文不空，未来会强校验
    String businessType();
    //业务类型中文
//    String businessName();
    //业务类型描述
    String businessDescription() default "无";


}
