package com.elitescloud.boot.log.common;

import com.elitescloud.boot.log.operationlog.BusinessParmObjectTypeEnum;
import com.elitescloud.boot.log.operationlog.OperationTypeEnum;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-11 19:16
 */

@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface BusinessOperationAnnotation {

    //业务类型
//    String businessType();

    //业务参数，用于业务查询
    String businessParam() default "-";

    //操作类型枚举
    OperationTypeEnum operationType();

    //操作描述
    String operationDescription();

    //是否记录日志
    boolean logEnabled() default false;

    //是否记录入参
    boolean argsJsonEnabled() default false;
    //是否记录出参
    boolean resultJsonEnabled() default false;
    //业务入参对象的取值名称-当前版本不支持
    BusinessParmObjectTypeEnum businessParamObjectType() default BusinessParmObjectTypeEnum.ALL;
    //暂无用-业务参数取值key
    String businessParamValueKey() default "";



}
