package com.elitescloud.boot.log.common;

import java.time.LocalDateTime;

/**
 * 日志存储接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/18
 */
public interface LogStorable {

    /**
     * 存储日志
     *
     * @param log 日志信息
     */
    void storage(Object log);

    /**
     * 删除过期日志
     * <p>
     * 删除过期时间之前的所有日志
     *
     * @param logType     日志对象类型
     * @param expiredTime 过期时间
     */
    void clearExpired(Class<?> logType, LocalDateTime expiredTime);
}
