package com.elitescloud.boot.log.common;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;

/**
 * 响应体体脱敏.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/22
 */
public interface ResponseBodyDesensitize {

    /**
     * 是否支持脱敏
     *
     * @param method  调用的方法
     * @param request 请求信息
     * @return 是否
     */
    boolean support(Method method, HttpServletRequest request);

    /**
     * 脱敏
     *
     * @param body 原响应体
     * @return 脱敏后的响应体
     */
    Object desensitize(Object body);
}
