package com.elitescloud.boot.log.model.bo;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 请求类日志基础类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/18
 */
@Data
@Accessors(chain = true)
public abstract class BaseRequestLogBO implements Serializable {
    private static final long serialVersionUID = 8737764595710226211L;

    /**
     * 请求时间
     */
    private LocalDateTime requestTime;

    /**
     * 响应时间
     */
    private LocalDateTime responseTime;

    /**
     * 请求token
     */
    private String token;

    /**
     * 请求浏览器user-agent
     */
    private String userAgent;

    /**
     * 请求方式，（GET、POST、DELETE、PUT、PATCH）
     */
    private String method;

    /**
     * 请求内容类型
     */
    private String reqContentType;

    /**
     * 请求路径
     */
    private String uri;

    /**
     * 请求接口名称，默认swagger注解获取
     */
    private String operation;

    /**
     * 请求端IP
     */
    private String reqIp;

    /**
     * 请求端外网IP
     */
    private String reqOuterIp;

    /**
     * 请求路径的查询参数
     */
    private String queryParams;

    /**
     * 请求体
     */
    private List<Object> requestBody;

    /**
     * 状态码
     */
    private Integer resultCode;

    /**
     * 响应结果信息
     */
    private String msg;

    /**
     * 响应结果
     */
    private Object result;

    /**
     * 请求异常
     */
    private Throwable throwable;
}
