package com.elitescloud.boot.log.model.bo;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 登录日志.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/18
 */
@Data
@Accessors(chain = true)
public class LoginLogBO extends BaseRequestLogBO {
    private static final long serialVersionUID = -5125120081035791711L;

    /**
     * 登录方式，（INNER-内部登录、OAUTH2-OAuth2授权登录、SSO-单点登录）
     */
    private String loginMethod;

    /**
     * 登录类型，（password-账号密码登录、mobile_pwd-手机号密码登录、mobile_sms-手机号短信登录，wx_minapp-微信小程序登录，account_pwd-通用账号登录）
     */
    private String loginType;

    /**
     * 登录终端，（BACKEND-管理端、APP-APP端、APPLET-小程序）
     */
    private String terminal;

    /**
     * 用户详细信息，脱敏的相关参数，JSON格式（支持配置是否记录）
     */
    private Object userDetailObj;
}
