package com.elitescloud.boot.log.model.bo;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author James.Huang
 * @version 2022.1
 * @date 2023/6/28 11:09
 * @Description:
 */
@Data
public class OperationLogVO {
    //触发端
    private String triggerTerminal;
    //系统模块
    private String sysModel;
    //操作类型
    private String operationType;
    //操作用户
    private String operationUser;
    //请求地址
    private String operationUrl;
    //操作时间
    private LocalDateTime operationTime;
    //操作IP
    private String operationIp;
    //操作状态
    private String operationStatus;
    //请求参数
    private String requestParam;
    //返回参数
    private String responseParam;
    //uuid,后续埋点日志使用
    private String logId;
    //请求方式
    private String requestMethod;
    //异常描述
    private String exceptionDesc;

    @Override
    public String toString() {
        return "OperationLogVO-Log-Use{" +
                "[logId='" + logId + '\'' +"]"+
                ", [triggerTerminal='" + triggerTerminal + '\'' +"]"+
                ", [sysModel='" + sysModel + '\'' +"]"+
                ", [operationUser='" + operationUser + '\'' +"]"+
                ", [operationUrl='" + operationUrl + '\'' +"]"+
                ", [operationType='" + operationType + '\'' +"]"+
                ", [operationTime='" + operationTime + '\'' +"]"+
                ", [operationIp='" + operationIp + '\'' +"]"+
                ", [operationStatus='" + operationStatus + '\'' +"]"+
                ", [requestParam='" + requestParam + '\'' +"]"+
                ", [responseParam='" + responseParam + '\'' +"]"+
                ", [requestMethod='" + requestMethod + '\'' +"]"+
                ", [exceptionDesc='" + exceptionDesc + '\'' +"]"+
                '}';
    }

}
