package com.elitescloud.boot.log.operationlog;

import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :   业务参数对象取值类型
 * @date : 2023-11-27 19:54
 */
public enum BusinessParmObjectTypeEnum {
    ALL("全部入参"),
//    PARAM_VALUE("指定入参值"),
    ;

    /**
     * 描述
     */
    private final String description;

    BusinessParmObjectTypeEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, TenantIsolateStrategy> VALUE_MAP = Arrays.stream(TenantIsolateStrategy.values()).collect(Collectors.toMap(TenantIsolateStrategy::name, t -> t, (t1, t2) -> t1));

    public static TenantIsolateStrategy parse(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.get(value);
    }
}
