package com.elitescloud.boot.log.operationlog;

/**
 * @author : chen.niu
 * @description : 自定义TOPIC消息发送消息  采用spring cloud stream ，
 * 默认rocketmq  需要配置：spring.cloud.stream.rocketmq.binder.name-server=XXX.XXX.XXX.1:9876
 * @date : 2023-11-28 17:40
 */

import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.stream.function.StreamBridge;

@Slf4j
public class DynamicMessageService {

    private final StreamBridge streamBridge;

    public DynamicMessageService(StreamBridge streamBridge) {
        this.streamBridge = streamBridge;
    }

    public boolean sendMessage(String destination, Object message) {
        var isSuccess = streamBridge.send(destination, message);
        if (log.isTraceEnabled()) {
            log.trace("动态MQ消息发送：{}-{}", isSuccess, message);
        }
        return isSuccess;
    }

}
