package com.elitescloud.boot.log.operationlog;

import com.elitescloud.cloudt.common.base.ApiResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.env.Environment;

/**
 * @author : chen.niu
 * @description : 关闭操作日志实现
 * @date : 2023-11-28 17:41
 */
@Slf4j
public class OperationLogMqMessageDefaultServiceImpl
        implements OperationLogMqMessageService {
    private final Environment environment;

    public OperationLogMqMessageDefaultServiceImpl(Environment environment) {
        this.environment = environment;
    }

    @Override
    public ApiResult<String> sendSyncOperationLogMqMessage(OperationLogDTO operationLogDTO) {
        log.info("操作日志配置关闭，不发送日志: {}",operationLogDTO);
         return ApiResult.ok("操作日志配置关闭，不发送日志");
    }

    @Override
    public ApiResult<String> sendAsyncOperationLogMqMessage(OperationLogDTO operationLogDTO) {
        log.info("操作日志配置关闭，不发送日志: {}",operationLogDTO);
        return ApiResult.ok("操作日志配置关闭，不发送日志");
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(
            Enum businessType, String businessParam,
            OperationTypeEnum operationType, String operationDescription) {
        return OperationLogMqMessageServiceImpl.getOperationLogDTO(businessType.name(),
                businessParam,
                operationType, operationDescription,environment);
     }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(String businessType, String businessParam, OperationTypeEnum operationType, String operationDescription) {
        return OperationLogMqMessageServiceImpl.getOperationLogDTO(businessType,
                businessParam,
                operationType, operationDescription,environment);
    }




}
