package com.elitescloud.boot.log.operationlog;

import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :  新增，修改，删除，审批，导出，导入，查询，其他
 * @date : 2023-11-27 19:54
 */
public enum OperationTypeEnum {
    ADD("创建"),
    UPDATE("编辑"),
    DELETE("删除"),
    APPROVE("审批"),
    EXPORT("导出"),
    IMPORT("导入"),
    SELECT("查询"),
    ELSE("其他"),
    ;

    /**
     * 描述
     */
    private final String description;

    OperationTypeEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, TenantIsolateStrategy> VALUE_MAP = Arrays.stream(TenantIsolateStrategy.values()).collect(Collectors.toMap(TenantIsolateStrategy::name, t -> t, (t1, t2) -> t1));

    public static TenantIsolateStrategy parse(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.get(value);
    }
}
