package com.elitescloud.boot.log.provider.storage;

import com.elitescloud.boot.log.LogProperties;
import com.elitescloud.boot.log.model.entity.AccessLogEntity;
import com.elitescloud.boot.log.model.entity.LoginLogEntity;
import lombok.extern.log4j.Log4j2;

import java.time.LocalDateTime;

/**
 * 日志打印.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/18
 */
@Log4j2
public class LogPrintStorage extends AbstractLogStorage {

    public LogPrintStorage(LogProperties logProperties) {
        super(logProperties);
    }

    @Override
    public void saveAccessLog(AccessLogEntity accessLogEntity) {
        log.info("Access-Log: {}", () -> obj2Json(accessLogEntity));
    }

    @Override
    public void saveLoginLog(LoginLogEntity loginLogEntity) {
        log.info("Login-Log: {}", () -> obj2Json(loginLogEntity));
    }

    @Override
    public void removeExpiredAccessLog(LocalDateTime expiredTime) {
        // 不做处理
    }

    @Override
    public void removeExpiredLoginLog(LocalDateTime expiredTime) {
        // 不做处理
    }
}
