/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.interceptor;

import com.elitescloud.boot.log.common.BusinessObjectAnnotation;
import com.elitescloud.boot.log.common.BusinessOperationAnnotation;
import com.elitescloud.boot.log.operationlog.OperationLogDTO;
import com.elitescloud.boot.log.operationlog.OperationLogMqMessageService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.time.Instant;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.web.bind.annotation.RestController;

@Aspect
public class BusinessOperationAspect {
    private static final Logger log = LoggerFactory.getLogger(BusinessOperationAspect.class);
    public static final String AUTO = "auto";
    private final OperationLogMqMessageService operationLogService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public BusinessOperationAspect(OperationLogMqMessageService operationLogService) {
        this.operationLogService = operationLogService;
    }

    @Around(value="@annotation(businessOperationAnnotation)")
    public Object logBusinessOperation(ProceedingJoinPoint joinPoint, BusinessOperationAnnotation businessOperationAnnotation) throws Throwable {
        if (!joinPoint.getTarget().getClass().isAnnotationPresent(RestController.class)) {
            log.error("\u6ce8\u89e3\u4f4d\u7f6e\u5f02\u5e38\uff1a{} BusinessOperationAnnotation \u89c4\u8303\u5e94\u7528\u5728  @RestController classes\u7684\u65b9\u6cd5\u4e2d", (Object)joinPoint.getTarget().getClass().getName());
        }
        if (!joinPoint.getTarget().getClass().isAnnotationPresent(BusinessObjectAnnotation.class)) {
            log.error("\u6ce8\u89e3\u5f02\u5e38\uff0c\u8df3\u8fc7\uff0c\u7ee7\u7eed\u6267\u884c\u4e1a\u52a1\u4ee3\u7801\uff1a{} BusinessOperationAnnotation \u89c4\u8303\u5e94\u7528\u5728  @BusinessObjectAnnotation classes\u7684\u65b9\u6cd5\u4e2d", (Object)joinPoint.getTarget().getClass().getName());
            return joinPoint.proceed();
        }
        if (businessOperationAnnotation.logEnabled()) {
            Instant start = Instant.now();
            String argsJson = "";
            if (businessOperationAnnotation.argsJsonEnabled()) {
                argsJson = this.convertToJson(joinPoint.getArgs());
            }
            Object result = joinPoint.proceed();
            String resultJson = "";
            if (businessOperationAnnotation.resultJsonEnabled()) {
                resultJson = this.convertToJson(result);
            }
            BusinessObjectAnnotation businessObjectAnnotation = joinPoint.getTarget().getClass().getAnnotation(BusinessObjectAnnotation.class);
            long timeElapsed = Duration.between(start, Instant.now()).toMillis();
            this.logOperation(argsJson, resultJson, timeElapsed, businessObjectAnnotation, businessOperationAnnotation);
            return result;
        }
        return joinPoint.proceed();
    }

    @Around(value="@within(businessObjectAnnotation)")
    public Object checkBusinessObjectAnnotation(ProceedingJoinPoint joinPoint, BusinessObjectAnnotation businessObjectAnnotation) throws Throwable {
        if (!joinPoint.getTarget().getClass().isAnnotationPresent(RestController.class)) {
            log.error("\u6ce8\u89e3\u4f4d\u7f6e\u5f02\u5e38\uff1a{} BusinessObjectAnnotation \u89c4\u8303\u5e94\u7528\u5728 @RestController classes", (Object)joinPoint.getTarget().getClass().getName());
        }
        return joinPoint.proceed();
    }

    private void logOperation(String argsJson, String resultJson, long timeElapsed, BusinessObjectAnnotation businessObjectAnnotation, BusinessOperationAnnotation annotation) {
        try {
            OperationLogDTO operationLogDTO = this.operationLogService.quickNewOperationLogDTO(businessObjectAnnotation.businessType().split(":")[0], annotation.businessParam(), annotation.operationType(), annotation.operationDescription());
            operationLogDTO.setDelayed(timeElapsed);
            operationLogDTO.setOperationAfterData(argsJson);
            operationLogDTO.setOperationBeforeData(resultJson);
            operationLogDTO.setSource(AUTO);
            ApiResult<String> apiResult = this.operationLogService.sendAsyncOperationLogMqMessage(operationLogDTO);
            if (!apiResult.isSuccess()) {
                log.error("\u64cd\u4f5c\u65e5\u5fd7\uff1a\u6d88\u606f\u53d1\u9001\u5931\u8d25 - {}", (Object)apiResult.getErrorMsg());
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u65e5\u5fd7\uff1a\u8bb0\u5f55\u5931\u8d25 - {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private String convertToJson(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u65e5\u5fd7\uff1aJSON\u8f6c\u6362\u5f02\u5e38 - {}", (Object)e.getMessage(), (Object)e);
            return "\u8f6c\u6362\u5f02\u5e38: " + e.getMessage();
        }
    }

    private BusinessOperationAnnotation obtainAnnotation(ProceedingJoinPoint point) {
        if (point instanceof MethodInvocationProceedingJoinPoint) {
            BusinessOperationAnnotation annotation = ((MethodSignature)point.getSignature()).getMethod().getAnnotation(BusinessOperationAnnotation.class);
            return annotation;
        }
        return null;
    }
}

